/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityNetherBrickGolem
extends GolemBase {
    public static final String ALLOW_FIRE_SPECIAL = "Allow Special: Burn Enemies";

    public EntityNetherBrickGolem(World world) {
        super(world, Config.NETHERBRICK.getBaseAttack(), Blocks.field_150385_bj);
        this.field_70178_ae = true;
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityNetherBrickGolem.makeGolemTexture("nether_brick");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (Config.NETHERBRICK.getBoolean(ALLOW_FIRE_SPECIAL)) {
                entity.func_70015_d(2 + this.field_70146_Z.nextInt(5));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.NETHERBRICK.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 4 + this.field_70146_Z.nextInt(8 + lootingLevel);
        this.addDrop(dropList, new ItemStack(Items.field_151130_bT, size), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

