/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIPlaceRandomBlocksStrictly;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityNetherWartGolem
extends GolemBase {
    public static final Block NETHERWART = Blocks.field_189878_dg;
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Netherwart";
    public static final String FREQUENCY = "Netherwart Frequency";
    public static final String DROP_NETHERWART_BLOCK = "Drop Netherwart Blocks";

    public EntityNetherWartGolem(World world) {
        super(world, Config.NETHERWART.getBaseAttack(), NETHERWART);
        this.setCanSwim(true);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        IBlockState[] flowers = new IBlockState[]{Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(0)), Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(1)), Blocks.field_150388_bm.func_176223_P().func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(2))};
        Block[] soils = new Block[]{Blocks.field_150425_aM};
        boolean spawn = Config.NETHERWART.getBoolean(ALLOW_SPECIAL);
        int freq = Config.NETHERWART.getInt(FREQUENCY);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlaceRandomBlocksStrictly((GolemBase)this, freq, flowers, soils, spawn));
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityNetherWartGolem.makeGolemTexture("nether_wart");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.NETHERWART.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int max;
        int min;
        Item netherwart;
        if (Config.NETHERWART.getBoolean(DROP_NETHERWART_BLOCK)) {
            netherwart = Item.func_150898_a((Block)NETHERWART);
            min = 0;
            max = 4;
        } else {
            netherwart = Items.field_151075_bm;
            min = 1;
            max = 9;
        }
        this.addDrop(dropList, netherwart, 0, min, max, 90 + lootingLevel * 2);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }
}

