/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemLightProvider;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntitySeaLanternGolem
extends GolemLightProvider {
    public EntitySeaLanternGolem(World world) {
        super(world, Config.SEA_LANTERN.getBaseAttack(), Blocks.field_180398_cJ, GolemLightProvider.EnumLightLevel.WATER_FULL);
        this.tickDelay = 1;
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySeaLanternGolem.makeGolemTexture("sea_lantern");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.SEA_LANTERN.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + this.field_70146_Z.nextInt(2 + lootingLevel);
        this.addDrop(dropList, new ItemStack(Blocks.field_180398_cJ, size > 4 ? 4 : size), 100);
        this.addDrop(dropList, Items.field_179562_cC, 0, 1, 3, 4 + lootingLevel * 5);
        this.addDrop(dropList, Items.field_179563_cD, 0, 1, 3, 4 + lootingLevel * 5);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }
}

