/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.events.SpongeGolemSoakEvent;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntitySpongeGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Absorb Water";
    public static final String INTERVAL = "Water Soaking Frequency";
    public static final String RANGE = "Water Soaking Range";
    public static final String PARTICLES = "Can Render Sponge Particles";

    public EntitySpongeGolem(World world) {
        super(world, Config.SPONGE.getBaseAttack(), Blocks.field_150360_v);
        this.setCanSwim(true);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySpongeGolem.makeGolemTexture("sponge");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        int interval = Config.SPONGE.getInt(INTERVAL);
        if (Config.SPONGE.getBoolean(ALLOW_SPECIAL) && (interval <= 1 || this.field_70173_aa % interval == 0)) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)) + 2;
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos center = new BlockPos(x, y, z);
            SpongeGolemSoakEvent event = new SpongeGolemSoakEvent(this, center, Config.SPONGE.getInt(RANGE));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() != Event.Result.DENY) {
                event.replaceWater();
            }
        }
        if (Config.SPONGE.getBoolean(PARTICLES) && Math.abs(this.field_70159_w) < 0.05 && Math.abs(this.field_70179_y) < 0.05 && this.field_70170_p.field_72995_K) {
            EnumParticleTypes particle = this.func_70027_ad() ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.WATER_SPLASH;
            double x = this.field_70146_Z.nextDouble() - 0.5 * (double)this.field_70130_N * 0.6;
            double y = this.field_70146_Z.nextDouble() * ((double)this.field_70131_O - 0.75);
            double z = this.field_70146_Z.nextDouble() - 0.5 * (double)this.field_70130_N;
            this.field_70170_p.func_175688_a(particle, this.field_70165_t + x, this.field_70163_u + y, this.field_70161_v + z, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.field_70146_Z.nextDouble() - 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.SPONGE.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + this.field_70146_Z.nextInt(3 + lootingLevel);
        this.addDrop(dropList, new ItemStack(Item.func_150898_a((Block)Blocks.field_150360_v), size > 4 ? 4 : size), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187554_ai;
    }
}

