/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorizedMultiTextured;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityStainedClayGolem
extends GolemColorizedMultiTextured {
    public static final String DROP_META = "Drop Metadata";
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeGolemTexture("stained_clay");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeGolemTexture("stained_clay_grayscale");

    public EntityStainedClayGolem(World world) {
        super(world, Config.STAINED_CLAY.getBaseAttack(), Blocks.field_150406_ce, TEXTURE_BASE, TEXTURE_OVERLAY, ItemDye.field_150922_c);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.STAINED_CLAY.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int keyReturn = Config.STAINED_CLAY.getInt(DROP_META);
        int meta = keyReturn < 0 ? 15 - this.getTextureNum() : keyReturn;
        int size = 1 + lootingLevel + this.field_70146_Z.nextInt(3);
        this.addDrop(dropList, new ItemStack(Blocks.field_150406_ce, size > 4 ? 4 : size, meta), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

