/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class GolemMultiTextured
extends GolemBase {
    protected static final DataParameter<Byte> DATA_TEXTURE = EntityDataManager.func_187226_a(GolemMultiTextured.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final String NBT_TEXTURE = "GolemTextureData";
    public final ResourceLocation[] textures;

    public GolemMultiTextured(World world, float attack, ItemStack pick, String prefix, String[] textureNames) {
        super(world, attack, pick);
        this.textures = new ResourceLocation[textureNames.length];
        for (String s : textureNames) {
            this.textures[n] = GolemBase.makeGolemTexture(this.getModId(), prefix + "_" + s);
        }
    }

    @Override
    protected ResourceLocation applyTexture() {
        return GolemMultiTextured.makeGolemTexture("clay");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_TEXTURE, (Object)0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (stack != null) {
            return super.func_184645_a(player, hand, stack);
        }
        int incremented = (this.getTextureNum() + 1) % this.textures.length;
        this.setTextureNum((byte)incremented);
        player.func_184609_a(hand);
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa == 2) {
            this.setTextureType(this.getTextureFromArray(this.getTextureNum()));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a(NBT_TEXTURE, (byte)this.getTextureNum());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(NBT_TEXTURE));
    }

    @Override
    public boolean doesInteractChangeTexture() {
        return true;
    }

    public void setTextureNum(byte toSet) {
        this.setTextureNum(toSet, true);
    }

    public void setTextureNum(byte toSet, boolean updateInstantly) {
        this.func_184212_Q().func_187227_b(DATA_TEXTURE, (Object)toSet);
        if (updateInstantly) {
            this.setTextureType(this.getTextureFromArray(this.getTextureNum()));
        }
    }

    public int getTextureNum() {
        return ((Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE)).byteValue();
    }

    public int getNumTextures() {
        return this.textures != null ? Integer.valueOf(this.textures.length) : null;
    }

    public int getMaxTextureNum() {
        return this.getNumTextures() - 1;
    }

    public ResourceLocation[] getTextureArray() {
        return this.textures;
    }

    public void updateTexture() {
        this.setTextureType(this.getTextureFromArray(this.getTextureNum()));
    }

    public ResourceLocation getTextureFromArray(int index) {
        return this.textures[index % this.textures.length];
    }

    public abstract String getModId();
}

