/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity.ai;

import com.golems.entity.GolemBase;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIPlaceRandomBlocks
extends EntityAIBase {
    public final GolemBase golem;
    public final int tickDelay;
    public final IBlockState[] plantables;
    public final Block[] plantSupports;
    public final boolean checkSupports;
    public final Predicate<EntityAIPlaceRandomBlocks> canExecute;

    public EntityAIPlaceRandomBlocks(GolemBase golemBase, int ticksBetweenPlanting, IBlockState[] plants, Block[] soils, Predicate<EntityAIPlaceRandomBlocks> pred) {
        this.func_75248_a(8);
        this.golem = golemBase;
        this.tickDelay = ticksBetweenPlanting;
        this.plantables = plants;
        this.plantSupports = soils;
        this.canExecute = pred;
        this.checkSupports = soils != null;
    }

    public EntityAIPlaceRandomBlocks(GolemBase golemBase, int ticksBetweenPlanting, IBlockState[] plants, Predicate<EntityAIPlaceRandomBlocks> p) {
        this(golemBase, ticksBetweenPlanting, plants, null, p);
    }

    public boolean func_75250_a() {
        return this.golem.field_70170_p.field_73012_v.nextInt(this.tickDelay) == 0 && this.canExecute.test(this);
    }

    public void func_75249_e() {
        int x = MathHelper.func_76128_c((double)this.golem.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.golem.field_70163_u - (double)0.2f - this.golem.func_70033_W()));
        int z = MathHelper.func_76128_c((double)this.golem.field_70161_v);
        BlockPos below = new BlockPos(x, y, z);
        Block blockBelow = this.golem.field_70170_p.func_180495_p(below).func_177230_c();
        if (this.golem.field_70170_p.func_175623_d(below.func_177981_b(1)) && this.isPlantSupport(this.golem.field_70170_p, below)) {
            this.setToPlant(this.golem.field_70170_p, below.func_177981_b(1));
            return;
        }
    }

    public boolean func_75253_b() {
        return false;
    }

    public boolean setToPlant(World world, BlockPos pos) {
        IBlockState state = this.plantables[world.field_73012_v.nextInt(this.plantables.length)];
        return world.func_180501_a(pos, state, 2);
    }

    public boolean isPlantSupport(World world, BlockPos pos) {
        if (!this.checkSupports) {
            return true;
        }
        Block at = world.func_180495_p(pos).func_177230_c();
        if (this.plantSupports != null && this.plantSupports.length > 0) {
            for (Block b : this.plantSupports) {
                if (at != b) continue;
                return true;
            }
        }
        return false;
    }
}

