/*
 * Decompiled with CFR 0.152.
 */
package com.golems.events;

import com.golems.entity.GolemBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GolemBuildEvent
extends Event {
    public final World worldObj;
    public final BlockPos headPos;
    public final Block blockBelow;
    public final IBlockState blockState;
    public final boolean isGolemXAligned;
    public final boolean areBlocksSameMeta;
    private GolemBase theGolem;
    private boolean isGolemBanned;

    public GolemBuildEvent(World world, BlockPos pos, boolean isXAligned) {
        this.worldObj = world;
        this.headPos = pos;
        this.blockBelow = world.func_180495_p(pos.func_177979_c(1)).func_177230_c();
        this.blockState = world.func_180495_p(pos.func_177979_c(1));
        this.isGolemXAligned = isXAligned;
        this.areBlocksSameMeta = this.getAreGolemBlocksSameMeta();
        this.theGolem = null;
        this.isGolemBanned = false;
    }

    public void setGolem(GolemBase golem, boolean isAllowedByConfig) {
        this.theGolem = golem;
        this.isGolemBanned = !isAllowedByConfig;
    }

    public void setGolem(GolemBase golem) {
        this.setGolem(golem, true);
    }

    public void setIsGolemBanned(boolean toSet) {
        this.isGolemBanned = toSet;
    }

    public GolemBase getGolem() {
        return this.theGolem;
    }

    public boolean isGolemNull() {
        return this.theGolem == (GolemBase)null;
    }

    public boolean isGolemBanned() {
        return this.isGolemBanned;
    }

    protected boolean getAreGolemBlocksSameMeta() {
        BlockPos[] armsX = new BlockPos[]{this.headPos.func_177979_c(1).func_177985_f(1), this.headPos.func_177979_c(1).func_177965_g(1)};
        BlockPos[] armsZ = new BlockPos[]{this.headPos.func_177979_c(1).func_177964_d(1), this.headPos.func_177979_c(1).func_177970_e(1)};
        int metaBelow1 = this.blockBelow.func_176201_c(this.blockState);
        IBlockState state = this.worldObj.func_180495_p(this.headPos.func_177979_c(2));
        int metaBelow2 = this.blockBelow.func_176201_c(state);
        state = this.isGolemXAligned ? this.worldObj.func_180495_p(armsX[0]) : this.worldObj.func_180495_p(armsZ[0]);
        int metaArm1 = this.blockBelow.func_176201_c(state);
        state = this.isGolemXAligned ? this.worldObj.func_180495_p(armsX[1]) : this.worldObj.func_180495_p(armsZ[1]);
        int metaArm2 = this.blockBelow.func_176201_c(state);
        return metaBelow1 == metaBelow2 && metaBelow2 == metaArm1 && metaArm1 == metaArm2;
    }
}

