/*
 * Decompiled with CFR 0.152.
 */
package com.golems.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class GolemConfigSet {
    private Configuration config;
    private String golemName;
    private Map<String, Object> keys = new HashMap<String, Object>(4);
    private boolean canSpawn;
    private double maxHealth;
    private float baseAttack;
    private static final Boolean DEF_BOOL = false;
    private static final Integer DEF_INT = 0;
    private static final Float DEF_FLOAT = Float.valueOf(0.0f);

    public GolemConfigSet(Configuration configFile, String name, boolean spawn, double health, float attack) {
        this.config = configFile;
        this.golemName = name;
        this.setCanSpawn(spawn);
        this.setMaxHealth(health);
        this.setBaseAttack(attack);
        this.loadFromConfig();
    }

    public GolemConfigSet(Configuration configFile, String name, double health, float attack) {
        this(configFile, name, true, health, attack);
    }

    public GolemConfigSet loadFromConfig() {
        String category = this.getCategory();
        boolean spawn = this.config.getBoolean("Allow Golem", category, true, "Whether the " + this.golemName + " can be built");
        double health = this.config.getFloat("Golem Health", category, (float)this.getMaxHealth(), 0.0f, 999.0f, "Max health for this golem");
        float attack = this.config.getFloat("Golem Attack", category, this.getBaseAttack(), 0.0f, 300.0f, "Base attack damage dealt by this golem");
        this.setCanSpawn(spawn);
        this.setMaxHealth(health);
        this.setBaseAttack(attack);
        return this;
    }

    public int addKey(String key, int defaultValue, int min, int max, String comment) {
        String category = this.getCategory();
        int value = this.config.getInt(key, category, defaultValue, min, max, comment);
        this.keys.put(key, value);
        return value;
    }

    public float addKey(String key, float defaultValue, float min, float max, String comment) {
        String category = this.getCategory();
        float value = this.config.getFloat(key, category, defaultValue, min, max, comment);
        this.keys.put(key, Float.valueOf(value));
        return value;
    }

    public boolean addKey(String key, boolean defaultValue, String comment) {
        String category = this.getCategory();
        boolean value = this.config.getBoolean(key, category, defaultValue, comment);
        this.keys.put(key, value);
        return value;
    }

    public int getInt(String key) {
        if (!this.keys.containsKey(key)) {
            String error = "Did not find an integer value matching '" + key + "' in GolemConfigSet '" + this.golemName + "' - defaulting to " + DEF_INT.toString();
            System.err.print(error);
            this.keys.put(key, DEF_INT);
            return DEF_INT;
        }
        Object value = this.keys.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        System.err.print("Expected an Integer to be mapped to '" + key + "' in GolemConfigSet '" + this.golemName + "' but got " + value.toString() + " instead");
        return DEF_INT;
    }

    public float getFloat(String key) {
        if (!this.keys.containsKey(key)) {
            String error = "Did not find a float value matching '" + key + "' in GolemConfigSet '" + this.golemName + "' - defaulting to " + DEF_FLOAT.toString();
            System.err.print(error);
            this.keys.put(key, DEF_FLOAT);
            return DEF_FLOAT.floatValue();
        }
        Object value = this.keys.get(key);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        System.err.print("Expected a Float to be mapped to '" + key + "' in GolemConfigSet '" + this.golemName + "' but got " + value.toString() + " instead");
        return DEF_FLOAT.floatValue();
    }

    public boolean getBoolean(String key) {
        if (!this.keys.containsKey(key)) {
            String error = "Did not find a boolean value matching '" + key + "' in GolemConfigSet '" + this.golemName + "' - defaulting to " + DEF_BOOL.toString();
            System.err.print(error);
            this.keys.put(key, DEF_BOOL);
            return DEF_BOOL;
        }
        Object value = this.keys.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        System.err.print("Expected a Boolean to be mapped to '" + key + "' in GolemConfigSet '" + this.golemName + "' but got " + value.toString() + " instead");
        return DEF_BOOL;
    }

    public void setCanSpawn(boolean toSet) {
        this.canSpawn = toSet;
    }

    public boolean canSpawn() {
        return this.canSpawn;
    }

    public void setMaxHealth(double toSet) {
        this.maxHealth = toSet;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public void setBaseAttack(float toSet) {
        this.baseAttack = toSet;
    }

    public float getBaseAttack() {
        return this.baseAttack;
    }

    public String getCategory() {
        return this.golemName.toLowerCase().replace(' ', '_');
    }

    public Configuration getConfig() {
        return this.config;
    }
}

