/*
 * Decompiled with CFR 0.152.
 */
package com.golems.blocks;

import com.golems.entity.GolemBase;
import com.golems.events.GolemBuildEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockGolemHead
extends BlockDirectional {
    public BlockGolemHead() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149672_a(field_149766_f);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176736_b();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{field_176387_N});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        Block blockBelow1 = world.func_180495_p(pos.func_177979_c(1)).func_177230_c();
        Block blockBelow2 = world.func_180495_p(pos.func_177979_c(2)).func_177230_c();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (blockBelow1 == blockBelow2) {
            boolean flagX = BlockGolemHead.isGolemXAligned(world, pos);
            boolean flagZ = BlockGolemHead.isGolemZAligned(world, pos);
            IBlockState meta = world.func_180495_p(pos.func_177979_c(1));
            if (blockBelow1 == Blocks.field_150433_aE) {
                if (!world.field_72995_K) {
                    BlockGolemHead.removeGolemBody(world, pos);
                    EntitySnowman entitysnowman = new EntitySnowman(world);
                    System.out.print("[Extra Golems]: Building regular boring Snow Golem\n");
                    entitysnowman.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
                    world.func_72838_d((Entity)entitysnowman);
                }
                this.spawnParticles(world, x, y - 2, z);
            }
            if (flagX || flagZ) {
                if (!world.field_72995_K) {
                    if (blockBelow1 == Blocks.field_150339_S) {
                        BlockGolemHead.removeAllGolemBlocks(world, pos, flagX);
                        EntityIronGolem golem = new EntityIronGolem(world);
                        System.out.print("[Extra Golems]: Building regular boring Iron Golem\n");
                        golem.func_70849_f(true);
                        golem.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
                        world.func_72838_d((Entity)golem);
                        return;
                    }
                    GolemBuildEvent event = new GolemBuildEvent(world, pos, flagX);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isGolemNull() || event.isGolemBanned()) {
                        return;
                    }
                    BlockGolemHead.removeAllGolemBlocks(world, pos, flagX);
                    GolemBase golem = event.getGolem();
                    System.out.print("[Extra Golems]: Building golem " + golem.toString() + "\n");
                    golem.setPlayerCreated(true);
                    golem.func_70012_b((double)x + 0.5, (double)y - 1.95, (double)z + 0.5, 0.0f, 0.0f);
                    world.func_72838_d((Entity)golem);
                }
                this.spawnParticles(world, x, y - 2, z);
            }
        }
    }

    protected void spawnParticles(World world, int x, int y, int z) {
        for (int i1 = 0; i1 < 120; ++i1) {
            world.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, (double)x + world.field_73012_v.nextDouble(), (double)(y - 2) + world.field_73012_v.nextDouble() * 2.5, (double)z + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static boolean isGolemXAligned(World world, BlockPos headPos) {
        BlockPos[] armsX = new BlockPos[]{headPos.func_177979_c(1).func_177985_f(1), headPos.func_177979_c(1).func_177965_g(1)};
        Block below = world.func_180495_p(headPos.func_177979_c(1)).func_177230_c();
        return world.func_180495_p(armsX[0]).func_177230_c() == below && world.func_180495_p(armsX[1]).func_177230_c() == below;
    }

    public static boolean isGolemZAligned(World world, BlockPos headPos) {
        BlockPos[] armsZ = new BlockPos[]{headPos.func_177979_c(1).func_177964_d(1), headPos.func_177979_c(1).func_177970_e(1)};
        Block below = world.func_180495_p(headPos.func_177979_c(1)).func_177230_c();
        return world.func_180495_p(armsZ[0]).func_177230_c() == below && world.func_180495_p(armsZ[1]).func_177230_c() == below;
    }

    public static void removeAllGolemBlocks(World world, BlockPos pos, boolean isXAligned) {
        BlockGolemHead.removeGolemBody(world, pos);
        BlockGolemHead.removeGolemArms(world, pos, isXAligned);
    }

    public static void removeGolemBody(World world, BlockPos head) {
        world.func_175698_g(head);
        world.func_175698_g(head.func_177979_c(1));
        world.func_175698_g(head.func_177979_c(2));
    }

    public static void removeGolemArms(World world, BlockPos pos, boolean isXAligned) {
        if (isXAligned) {
            world.func_175698_g(pos.func_177979_c(1).func_177985_f(1));
            world.func_175698_g(pos.func_177979_c(1).func_177965_g(1));
        } else {
            world.func_175698_g(pos.func_177979_c(1).func_177964_d(1));
            world.func_175698_g(pos.func_177979_c(1).func_177970_e(1));
        }
    }
}

