/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityBookshelfGolem
extends GolemBase {
    private int[] goodEffects;

    public EntityBookshelfGolem(World world) {
        super(world, 1.5f, Blocks.field_150342_X);
        this.goodEffects = new int[]{Potion.field_76426_n.field_76415_H, Potion.field_76428_l.field_76415_H, Potion.field_76420_g.field_76415_H, Potion.field_76432_h.field_76415_H, Potion.field_76429_m.field_76415_H, Potion.field_76441_p.field_76415_H, Potion.field_76424_c.field_76415_H};
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityBookshelfGolem.makeGolemTexture("books");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.ALLOW_BOOKSHELF_SPECIAL && this.func_70651_bq().isEmpty() && this.field_70146_Z.nextInt(40) == 0) {
            this.func_70690_d(new PotionEffect(this.goodEffects[this.field_70146_Z.nextInt(this.goodEffects.length)], 200 + 100 * (1 + this.field_70146_Z.nextInt(5)), 1));
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(28.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 4 + this.field_70146_Z.nextInt(6 + lootingLevel);
        this.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151122_aG, size));
        this.addDropEntry(dropList, Blocks.field_150344_f, 0, 3, 12, 75);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149766_f.func_150498_e();
    }
}

