/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.ContainerPortableWorkbench;
import com.golems.entity.GolemBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public class EntityCraftingGolem
extends GolemBase {
    public EntityCraftingGolem(World world) {
        super(world, 2.0f, Blocks.field_150462_ai);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityCraftingGolem.makeGolemTexture("crafting");
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (!player.field_70170_p.field_72995_K && itemstack == null) {
            player.func_180468_a((IInteractionObject)new InterfaceCraftingGrid(player.field_70170_p, player.field_71081_bT));
            player.func_71029_a(StatList.field_181742_Z);
            player.func_71038_i();
        }
        return super.func_70085_c(player);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        this.addGuaranteedDropEntry(dropList, new ItemStack(Blocks.field_150462_ai, 1 + this.field_70146_Z.nextInt(2)));
        this.addDropEntry(dropList, Blocks.field_150344_f, 0, 1, 6, 70 + lootingLevel * 10);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.func_150498_e();
    }

    public static class InterfaceCraftingGrid
    extends BlockWorkbench.InterfaceCraftingTable {
        private final World world2;
        private final BlockPos position2;

        public InterfaceCraftingGrid(World worldIn, BlockPos pos) {
            super(worldIn, pos);
            this.world2 = worldIn;
            this.position2 = pos;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerPortableWorkbench(playerInventory, this.world2, this.position2);
        }
    }
}

