/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.Config;
import com.golems.init.GolemItems;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEndstoneGolem
extends GolemBase {
    protected int teleportDelay;
    protected double range;
    protected boolean canTeleport;
    protected boolean hasParticles;
    protected boolean avoidsArrows;
    protected int ticksBetweenIdleTeleports = 200;
    protected int chanceToTeleportWhenHurt = 75;

    public EntityEndstoneGolem(World world) {
        this(world, 8.0f, Blocks.field_150377_bs, 32.0, Config.ALLOW_ENDSTONE_SPECIAL, true);
    }

    public EntityEndstoneGolem(World world, float attack, Block pick, double teleportRange, boolean teleportingAllowed, boolean particles) {
        super(world, attack, pick);
        this.range = teleportRange;
        this.canTeleport = teleportingAllowed;
        this.hasParticles = particles;
        this.avoidsArrows = true;
    }

    public EntityEndstoneGolem(World world, float attack, double teleportRange, boolean teleportingAllowed, boolean particles) {
        this(world, attack, GolemItems.golemHead, teleportRange, teleportingAllowed, particles);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityEndstoneGolem.makeGolemTexture("end_stone");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        this.addDropEntry(dropList, Blocks.field_150377_bs, 0, 2, 2 + lootingLevel, 90);
        this.addDropEntry(dropList, Items.field_151079_bi, 0, 2, 4 + lootingLevel, 40 + lootingLevel * 10);
        this.addDropEntry(dropList, Items.field_151061_bv, 0, 1, 1 + lootingLevel, 6 + lootingLevel * 10);
    }

    protected boolean teleportTo(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, p_70825_1_, p_70825_3_, p_70825_5_, 0.0f);
        if (!this.canTeleport || MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean flag = false;
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70170_p.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                Block block = this.field_70170_p.func_180495_p(blockpos1).func_177230_c();
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                super.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int i = 0; this.hasParticles && i < short1; ++i) {
            double d9 = (double)i / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d6 = d3 + (this.field_70165_t - d3) * d9 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d7 = d4 + (this.field_70163_u - d4) * d9 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d8 = d5 + (this.field_70161_v - d5) * d9 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d6, d7, d8, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        double d1 = this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * this.range * 0.5;
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        return this.teleportTo(d0, d1, d2);
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (Config.ALLOW_ENDSTONE_WATER_HURT && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            for (int i = 0; i < 16 && !this.teleportRandomly(); ++i) {
            }
        }
        if (this.func_70643_av() != null) {
            this.func_70625_a((Entity)this.func_70643_av(), 100.0f, 100.0f);
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.teleportToEntity((Entity)this.func_70643_av());
            }
        } else if (this.field_70146_Z.nextInt(this.ticksBetweenIdleTeleports) == 0) {
            this.teleportRandomly();
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.hasParticles) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.func_70643_av() != null) {
                if (this.func_70643_av() instanceof EntityPlayer) {
                    if (this.func_70643_av().func_70068_e((Entity)this) < 64.0) {
                        this.teleportRandomly();
                    }
                    this.teleportDelay = 0;
                } else if (this.func_70643_av().func_70068_e((Entity)this) > 16.0 && this.teleportDelay++ >= 30 && this.teleportToEntity((Entity)this.func_70643_av())) {
                    this.teleportDelay = 0;
                }
            } else {
                this.teleportDelay = 0;
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource src, float amnt) {
        if (this.func_180431_b(src)) {
            return false;
        }
        if (this.avoidsArrows && src instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 16; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return super.func_70097_a(src, amnt);
        }
        if (this.field_70146_Z.nextInt(100) < this.chanceToTeleportWhenHurt || this.func_70643_av() != null && this.field_70146_Z.nextBoolean()) {
            this.teleportRandomly();
        }
        return super.func_70097_a(src, amnt);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3 vec3 = new Vec3(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.func_150498_e();
    }
}

