/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorized;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class EntityLeafGolem
extends GolemColorized {
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeGolemTexture("leaves");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeGolemTexture("leaves_grayscale");

    public EntityLeafGolem(World world) {
        super(world, 0.5f, (Block)Blocks.field_150362_t, BiomeGenBase.field_150583_P.field_76790_z, TEXTURE_BASE, TEXTURE_OVERLAY);
        this.setCanSwim(true);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.31);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.ALLOW_LEAF_SPECIAL && this.func_70660_b(Potion.field_76428_l) == null && this.field_70146_Z.nextInt(40) == 0) {
            this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200 + 20 * (1 + this.field_70146_Z.nextInt(8)), 1));
        }
        if (this.field_70173_aa % 10 == 2 && this.field_70170_p.field_72995_K) {
            BiomeGenBase biome = this.field_70170_p.func_180494_b(this.func_180425_c());
            long color = biome.func_180625_c(this.func_180425_c());
            this.setColor(color);
        }
        if (this.field_70181_x < -0.1) {
            this.field_70181_x *= 0.8;
        }
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        this.addGuaranteedDropEntry(dropList, new ItemStack((Block)Blocks.field_150362_t, lootingLevel + 1));
        this.addDropEntry(dropList, Blocks.field_150345_g, 0, 1, 1, 20 + lootingLevel * 10);
        this.addDropEntry(dropList, Items.field_151034_e, 0, 1, 1, 15 + lootingLevel * 10);
        this.addDropEntry(dropList, Items.field_151055_y, 0, 1, 2, 5 + lootingLevel * 10);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149779_h.func_150498_e();
    }
}

