/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemMultiTextured;
import com.golems.entity.ai.EntityAIPlaceBlocksRandomly;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityMushroomGolem
extends GolemMultiTextured {
    private static final String[] shroomTypes = new String[]{"red", "brown"};
    private final IBlockState[] mushrooms = new IBlockState[]{Blocks.field_150338_P.func_176223_P(), Blocks.field_150337_Q.func_176223_P()};
    private final Block[] soils = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh};

    public EntityMushroomGolem(World world) {
        super(world, 3.0f, Blocks.field_150419_aX, shroomTypes);
        this.setCanSwim(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlaceBlocksRandomly(this, Config.TWEAK_MUSHROOM, this.mushrooms, this.soils, Config.ALLOW_MUSHROOM_SPECIAL));
    }

    @Override
    public String getTexturePrefix() {
        return "shroom";
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 4 + this.field_70146_Z.nextInt(6 + lootingLevel * 2);
        BlockBush shroom = this.field_70146_Z.nextBoolean() ? Blocks.field_150337_Q : Blocks.field_150338_P;
        this.addGuaranteedDropEntry(dropList, new ItemStack((Block)shroom, size));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149779_h.func_150498_e();
    }
}

