/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityNetherBrickGolem
extends GolemBase {
    private int ticksStandingStill = 0;

    public EntityNetherBrickGolem(World world) {
        super(world, 6.5f, Blocks.field_150385_bj);
        this.field_70178_ae = true;
        this.field_70138_W = 1.0f;
        this.setCanSwim(true);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityNetherBrickGolem.makeGolemTexture("nether_brick");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (Config.ALLOW_NETHERBRICK_SPECIAL_FIRE) {
                entity.func_70015_d(2 + this.field_70146_Z.nextInt(5));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.ALLOW_NETHERBRICK_SPECIAL_LAVA) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos below = new BlockPos(x, y, z);
            Block b1 = this.field_70170_p.func_180495_p(below).func_177230_c();
            if (x == MathHelper.func_76128_c((double)this.field_70142_S) && z == MathHelper.func_76128_c((double)this.field_70136_U)) {
                if (++this.ticksStandingStill >= Config.TWEAK_NETHERBRICK && b1 == Blocks.field_150347_e && this.field_70146_Z.nextInt(16) == 0) {
                    this.field_70170_p.func_180501_a(below, Blocks.field_150353_l.func_176223_P(), 3);
                    this.ticksStandingStill = 0;
                }
            } else {
                this.ticksStandingStill = 0;
            }
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 4 + this.field_70146_Z.nextInt(8 + lootingLevel);
        this.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151130_bT, size));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.func_150498_e();
    }
}

