/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntitySpongeGolem
extends GolemBase {
    public EntitySpongeGolem(World world) {
        super(world, 1.5f, Blocks.field_150360_v);
        this.setCanSwim(true);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySpongeGolem.makeGolemTexture("sponge");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.ALLOW_SPONGE_SPECIAL && (Config.TWEAK_SPONGE_INTERVAL == 1 || this.field_70173_aa % Config.TWEAK_SPONGE_INTERVAL == 0)) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)) + 2;
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos center = new BlockPos(x, y, z);
            for (int i = -Config.TWEAK_SPONGE; i <= Config.TWEAK_SPONGE; ++i) {
                for (int j = -Config.TWEAK_SPONGE; j <= Config.TWEAK_SPONGE; ++j) {
                    for (int k = -Config.TWEAK_SPONGE; k <= Config.TWEAK_SPONGE; ++k) {
                        BlockPos pos;
                        Block b1;
                        if (!(center.func_177954_c((double)(x + i), (double)(y + j), (double)(z + k)) <= (double)(Config.TWEAK_SPONGE * Config.TWEAK_SPONGE)) || (b1 = this.field_70170_p.func_180495_p(pos = new BlockPos(x + i, y + j, z + k)).func_177230_c()) != Blocks.field_150355_j && b1 != Blocks.field_150358_i && b1.func_149688_o() != Material.field_151586_h) continue;
                        this.field_70170_p.func_175698_g(pos);
                    }
                }
            }
        }
        if (Config.ALLOW_SPONGE_PARTICLES && Math.abs(this.field_70159_w) < 0.05 && Math.abs(this.field_70179_y) < 0.05 && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.DRIP_WATER, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 0.6, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.75, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 0.6, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.9) * 0.5, new int[0]);
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + this.field_70146_Z.nextInt(3 + lootingLevel);
        this.addGuaranteedDropEntry(dropList, new ItemStack(Item.func_150898_a((Block)Blocks.field_150360_v), size > 4 ? 4 : size));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149779_h.func_150498_e();
    }
}

