/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorizedMultiTextured;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityStainedClayGolem
extends GolemColorizedMultiTextured {
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeGolemTexture("stained_clay");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeGolemTexture("stained_clay_grayscale");
    private static final int[] dyeColors = ItemDye.field_150922_c;

    public EntityStainedClayGolem(World world) {
        super(world, 3.0f, Blocks.field_150406_ce, TEXTURE_BASE, TEXTURE_OVERLAY, dyeColors);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(26.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int meta = Config.TWEAK_STAINED_CLAY < 0 ? 15 - this.getTextureNum() : Config.TWEAK_STAINED_CLAY;
        int size = 1 + lootingLevel + this.field_70146_Z.nextInt(3);
        this.addGuaranteedDropEntry(dropList, new ItemStack(Blocks.field_150406_ce, size > 4 ? 4 : size, meta));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.func_150498_e();
    }
}

