/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorizedMultiTextured;
import com.golems.init.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStainedGlassGolem
extends GolemColorizedMultiTextured {
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeGolemTexture("stained_glass");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeGolemTexture("stained_glass_grayscale");
    private static final int[] dyeColors = ItemDye.field_150922_c;

    public EntityStainedGlassGolem(World world) {
        super(world, 12.0f, (Block)Blocks.field_150399_cn, TEXTURE_BASE, TEXTURE_OVERLAY, dyeColors);
        this.setCanTakeFallDamage(true);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(9.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasTransparency() {
        return true;
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int meta = Config.TWEAK_STAINED_GLASS < 0 ? 15 - this.getTextureNum() : Config.TWEAK_STAINED_GLASS;
        int size = lootingLevel + this.field_70146_Z.nextInt(3 + lootingLevel);
        this.addGuaranteedDropEntry(dropList, new ItemStack((Block)Blocks.field_150399_cn, size > 4 ? 4 : size, meta));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149778_k.func_150498_e();
    }
}

