/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.init.GolemItems;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GolemColorized
extends GolemBase {
    protected long color;
    protected ResourceLocation base;
    protected ResourceLocation overlay;
    protected boolean hasBase;

    public GolemColorized(World world, float attack, Block pickBlock, long initial, ResourceLocation rBase, ResourceLocation rGrayscale) {
        super(world, attack, pickBlock);
        this.color = initial;
        this.base = rBase;
        this.overlay = rGrayscale;
        this.hasBase = this.base != null;
    }

    public GolemColorized(World world, float attack, long initial, ResourceLocation rBase, ResourceLocation rGrayscale) {
        this(world, attack, GolemItems.golemHead, initial, rBase, rGrayscale);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return GolemColorized.makeGolemTexture("clay");
    }

    public ResourceLocation getTextureBase() {
        return this.base;
    }

    public ResourceLocation getTextureToColor() {
        return this.overlay;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public void setColor(long toSet) {
        this.color = toSet;
    }

    public long getColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasTransparency() {
        return false;
    }
}

