/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.blocks.BlockLightProvider;
import com.golems.entity.GolemBase;
import com.golems.init.GolemItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GolemLightProvider
extends GolemBase {
    private EnumLightLevel lightLevel;

    public GolemLightProvider(World world, float attack, Block pick, EnumLightLevel light) {
        super(world, attack, pick);
        this.lightLevel = light;
    }

    public GolemLightProvider(World world, float attack, EnumLightLevel light) {
        this(world, attack, GolemItems.golemHead, light);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 2 == 0) {
            this.placeLightBlock();
        }
    }

    protected boolean placeLightBlock() {
        int[][] validPos;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int[] coord : validPos = new int[][]{{x, z}, {x + 1, z}, {x - 1, z}, {x, z + 1}, {x, z - 1}, {x + 1, z + 1}, {x - 1, z + 1}, {x + 1, z - 1}, {x - 1, z - 1}}) {
            int xPos = coord[0];
            int zPos = coord[1];
            for (int k = 0; k < 3; ++k) {
                int yPos = y + k + 1;
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                Block at = this.field_70170_p.func_180495_p(pos).func_177230_c();
                if (at.func_149688_o() == this.lightLevel.getMaterialToReplace()) {
                    return this.field_70170_p.func_175656_a(pos, this.lightLevel.getLightBlock().func_176223_P());
                }
                if (!(at instanceof BlockLightProvider)) continue;
                return false;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float f) {
        return 0xF000F0;
    }

    public float func_70013_c(float f) {
        return this.lightLevel.getBrightness();
    }

    public static enum EnumLightLevel {
        HALF(0.5f, Material.field_151579_a),
        FULL(1.0f, Material.field_151579_a),
        WATER_HALF(0.5f, Material.field_151586_h),
        WATER_FULL(1.0f, Material.field_151586_h);

        private final float light;
        private final Material replaceable;

        private EnumLightLevel(float brightness, Material canReplace) {
            this.light = brightness;
            this.replaceable = canReplace;
        }

        public Block getLightBlock() {
            switch (this) {
                case FULL: 
                case WATER_FULL: {
                    return GolemItems.blockLightSourceFull;
                }
                case HALF: 
                case WATER_HALF: {
                    return GolemItems.blockLightSourceHalf;
                }
            }
            return Blocks.field_150350_a;
        }

        public float getBrightness() {
            return this.light;
        }

        public Material getMaterialToReplace() {
            return this.replaceable;
        }
    }
}

