/*
 * Decompiled with CFR 0.152.
 */
package com.golems.init;

import com.golems.blocks.BlockGolemHead;
import com.golems.blocks.BlockLightProvider;
import com.golems.blocks.BlockPowerProvider;
import com.golems.blocks.TileEntityMovingLightSource;
import com.golems.blocks.TileEntityMovingPowerSource;
import com.golems.items.ItemBedrockGolem;
import com.golems.items.ItemGolemPaper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class GolemItems {
    public static Item golemPaper;
    public static Item spawnBedrockGolem;
    public static Block golemHead;
    public static Block blockLightSourceFull;
    public static Block blockLightSourceHalf;
    public static Block blockPowerSource;

    public static void mainRegistry() {
        GolemItems.initBlocks();
        GolemItems.initItems();
        GolemItems.register(TileEntityMovingLightSource.class, "TileEntityMovingLightSource");
        GolemItems.register(TileEntityMovingPowerSource.class, "TileEntityMovingPowerSource");
        GolemItems.register(golemPaper, "golem_paper");
        GolemItems.register(spawnBedrockGolem, "spawn_bedrock_golem");
        GolemItems.register(golemHead, "golem_head");
        GolemItems.register(blockLightSourceFull, "light_provider_full");
        GolemItems.register(blockLightSourceHalf, "light_provider_half");
        GolemItems.register(blockPowerSource, "power_provider_full");
    }

    private static void initBlocks() {
        golemHead = new BlockGolemHead();
        blockLightSourceFull = new BlockLightProvider(1.0f);
        blockLightSourceHalf = new BlockLightProvider(0.5f);
        blockPowerSource = new BlockPowerProvider();
    }

    private static void initItems() {
        golemPaper = new ItemGolemPaper();
        spawnBedrockGolem = new ItemBedrockGolem();
    }

    private static void register(Item item, String name) {
        item.func_77655_b(name).setRegistryName("golems", name);
        GameRegistry.registerItem((Item)item);
    }

    private static void register(Block block, String name) {
        block.func_149663_c(name).setRegistryName("golems", name);
        GameRegistry.registerBlock((Block)block, (String)block.getRegistryName());
    }

    private static void register(Class<? extends TileEntity> teClass, String name) {
        GameRegistry.registerTileEntity(teClass, (String)("golems." + name));
    }
}

