/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityCoalGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Blindness";

    public EntityCoalGolem(World world) {
        super(world, Config.COAL.getBaseAttack(), Blocks.field_150402_ci);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityCoalGolem.makeGolemTexture("coal");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.COAL.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            int BLIND_CHANCE = 4;
            if (Config.COAL.getBoolean(ALLOW_SPECIAL) && entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(4) == 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20 * (1 + this.field_70146_Z.nextInt(5)), 1));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70027_ad()) {
            this.func_70015_d(2);
        }
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(8 + lootingLevel * 2);
        this.addDrop(dropList, new ItemStack(Items.field_151044_h, size), 100);
        this.addDrop(dropList, Items.field_151044_h, 1, 1, size / 4, 40);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

