/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.ai.EntityAIPlaceRandomBlocks;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityMelonGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Flowers";
    public static final String FREQUENCY = "Flower Frequency";
    private IBlockState[] flowers;
    private final Block[] soils = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh, Blocks.field_150458_ak};

    public EntityMelonGolem(World world) {
        super(world, Config.MELON.getBaseAttack(), Blocks.field_150440_ba);
        this.setCanSwim(true);
        this.field_70714_bg.func_75776_a(2, this.makeFlowerAI());
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityMelonGolem.makeGolemTexture("melon");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.MELON.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 6 + this.field_70146_Z.nextInt(6 + lootingLevel * 4);
        this.addDrop(dropList, new ItemStack(Items.field_151127_ba, size), 100);
        this.addDrop(dropList, Items.field_151081_bc, 0, 1, 6 + lootingLevel, 20 + lootingLevel * 10);
        this.addDrop(dropList, Items.field_151060_bw, 0, 1, 1, 2 + lootingLevel * 10);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }

    protected EntityAIBase makeFlowerAI() {
        ArrayList<IBlockState> lFlowers = new ArrayList<IBlockState>();
        for (BlockFlower.EnumFlowerType enumFlowerType : BlockFlower.EnumFlowerType.values()) {
            lFlowers.add(enumFlowerType.func_176964_a().func_180346_a().func_176203_a(enumFlowerType.func_176968_b()));
        }
        for (BlockFlower.EnumFlowerType enumFlowerType : BlockTallGrass.EnumType.values()) {
            lFlowers.add(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)enumFlowerType));
        }
        this.flowers = lFlowers.toArray(new IBlockState[lFlowers.size()]);
        int freq = Config.MELON.getInt(FREQUENCY);
        boolean allowed = Config.MELON.getBoolean(ALLOW_SPECIAL);
        return new EntityAIPlaceRandomBlocks(this, freq, this.flowers, this.soils, allowed);
    }
}

