/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.main.GolemItems;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityRedstoneGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Redstone Power";
    public static final String POWER = "Redstone Power Level";
    protected boolean CAN_POWER;
    protected int powerOutput;
    protected int tickDelay;

    public EntityRedstoneGolem(World world) {
        this(world, Config.REDSTONE.getBaseAttack(), Blocks.field_150451_bX, Config.REDSTONE.getInt(POWER), Config.REDSTONE.getBoolean(ALLOW_SPECIAL));
    }

    public EntityRedstoneGolem(World world, float attack, Block pick, int power, boolean CONFIG_ALLOWS_POWERING) {
        super(world, attack, pick);
        this.setPowerOutput(power);
        this.CAN_POWER = CONFIG_ALLOWS_POWERING;
        this.tickDelay = 2;
    }

    public EntityRedstoneGolem(World world, float attack, int power, boolean CONFIG_ALLOWS_POWERING) {
        this(world, attack, GolemItems.golemHead, power, CONFIG_ALLOWS_POWERING);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityRedstoneGolem.makeGolemTexture("redstone");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.REDSTONE.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.CAN_POWER && (this.tickDelay <= 1 || this.field_70173_aa % this.tickDelay == 0)) {
            this.placePowerNearby();
        }
    }

    protected boolean placePowerNearby() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int k = -1; k < 3; ++k) {
            BlockPos at = new BlockPos(x, y + k, z);
            if (!this.field_70170_p.func_175623_d(at)) continue;
            return this.field_70170_p.func_175656_a(at, GolemItems.blockPowerSource.func_176203_a(this.getPowerOutput()));
        }
        return false;
    }

    public void setPowerOutput(int toSet) {
        this.powerOutput = toSet % 16;
    }

    public int getPowerOutput() {
        return this.powerOutput;
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(14 + lootingLevel * 4);
        this.addDrop(dropList, new ItemStack(Items.field_151137_ax, size > 36 ? 36 : size), 100);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

