/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.entity.GolemColorizedMultiTextured;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemDye;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStainedGlassGolem
extends GolemColorizedMultiTextured {
    public static final String DROP_META = "Drop Metadata";
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeGolemTexture("stained_glass");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeGolemTexture("stained_glass_grayscale");

    public EntityStainedGlassGolem(World world) {
        super(world, Config.STAINED_GLASS.getBaseAttack(), (Block)Blocks.field_150399_cn, TEXTURE_BASE, TEXTURE_OVERLAY, ItemDye.field_150922_c);
        this.setCanTakeFallDamage(true);
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.STAINED_GLASS.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasTransparency() {
        return true;
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int keyReturn = Config.STAINED_GLASS.getInt(DROP_META);
        int meta = keyReturn < 0 ? 15 - this.getTextureNum() : keyReturn;
        int size = lootingLevel + this.field_70146_Z.nextInt(3 + lootingLevel);
        this.addDrop(dropList, (Block)Blocks.field_150399_cn, meta, 0, size > 4 ? 4 : size, 50 + lootingLevel * 10);
        this.addDrop(dropList, (Block)Blocks.field_150397_co, meta, 1, 5 + lootingLevel, 80 + lootingLevel * 10);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187561_bM;
    }
}

