/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityStrawGolem
extends GolemBase {
    public EntityStrawGolem(World world) {
        super(world, Config.STRAW.getBaseAttack(), Blocks.field_150407_cf);
        this.setCanSwim(true);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityStrawGolem.makeGolemTexture("straw");
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.STRAW.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 6 + this.field_70146_Z.nextInt(8 + lootingLevel * 4);
        this.addDrop(dropList, new ItemStack(Items.field_151015_O, size), 100);
        this.addDrop(dropList, Items.field_151014_N, 0, 1, 3 + lootingLevel * 2, 10 + lootingLevel * 10);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187668_ca;
    }
}

