/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityTNTGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Explode";
    protected final int MIN_EXPLOSION_RAD;
    protected final int MAX_EXPLOSION_RAD;
    protected final int FUSE_LEN;
    protected final int CHANCE_TO_EXPLODE_WHEN_ATTACKING;
    protected boolean canExplode;
    protected boolean isIgnited;
    protected boolean willExplode;
    protected int fuseTimer;

    public EntityTNTGolem(World world) {
        this(world, 2.5f, Blocks.field_150335_W, 3, 6, 50, 10, Config.TNT.getBoolean(ALLOW_SPECIAL));
    }

    public EntityTNTGolem(World world, float attack, Block pick, int minExplosionRange, int maxExplosionRange, int minFuseLength, int randomExplosionChance, boolean configAllowsExplode) {
        super(world, attack, pick);
        this.MIN_EXPLOSION_RAD = minExplosionRange;
        this.MAX_EXPLOSION_RAD = maxExplosionRange > minExplosionRange ? maxExplosionRange : minExplosionRange + 1;
        this.FUSE_LEN = minFuseLength;
        this.CHANCE_TO_EXPLODE_WHEN_ATTACKING = randomExplosionChance;
        this.canExplode = configAllowsExplode;
        this.resetIgnite();
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityTNTGolem.makeGolemTexture("tnt");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_110143_aJ() <= 1.0f) {
            this.ignite();
            this.fuseTimer = 1;
        }
        if (this.func_70027_ad()) {
            this.ignite();
        }
        if (this.func_70026_G() || this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > (double)(this.MIN_EXPLOSION_RAD * this.MIN_EXPLOSION_RAD)) {
            this.resetIgnite();
        }
        if (this.isIgnited) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            --this.fuseTimer;
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v - 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t - 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t - 0.75, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v - 0.75, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), 0.0, 0.5 * (0.5 - this.field_70146_Z.nextDouble()), new int[0]);
            }
            if (this.fuseTimer <= 0) {
                this.willExplode = true;
            }
        }
        if (this.willExplode) {
            this.explode();
        }
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.explode();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && !entity.field_70128_L && this.field_70146_Z.nextInt(100) < this.CHANCE_TO_EXPLODE_WHEN_ATTACKING && this.func_70068_e(entity) <= (double)(this.MIN_EXPLOSION_RAD * this.MIN_EXPLOSION_RAD)) {
            this.ignite();
        }
        return flag;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70015_d(Math.floorDiv(this.FUSE_LEN, 20));
                this.ignite();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return true;
    }

    protected void ignite() {
        if (!this.isIgnited) {
            this.isIgnited = true;
            this.fuseTimer = this.FUSE_LEN + this.field_70146_Z.nextInt(Math.floorDiv(this.FUSE_LEN, 2) + 1);
            if (!this.func_70026_G()) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
        }
    }

    protected void resetIgnite() {
        this.isIgnited = false;
        this.fuseTimer = this.FUSE_LEN + this.field_70146_Z.nextInt(Math.floorDiv(this.FUSE_LEN, 2) + 1);
        this.willExplode = false;
    }

    protected void explode() {
        if (this.canExplode) {
            if (!this.field_70170_p.field_72995_K) {
                boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.MIN_EXPLOSION_RAD + (float)this.field_70146_Z.nextInt(this.MAX_EXPLOSION_RAD - this.MIN_EXPLOSION_RAD), flag);
                this.func_70106_y();
            }
        } else {
            this.resetIgnite();
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 2 + this.field_70146_Z.nextInt(4);
        this.addDrop(dropList, new ItemStack(Items.field_151016_H, size), 100);
        this.addDrop(dropList, Blocks.field_150335_W, 0, 1, 1, lootingLevel * 30);
        this.addDrop(dropList, (Block)Blocks.field_150354_m, 0, 0, 4, 5 + lootingLevel * 10);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187668_ca;
    }
}

