/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemMultiTextured;
import com.golems.main.Config;
import com.golems.util.WeightedItem;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityWoolGolem
extends GolemMultiTextured {
    public static final String woolPrefix = "wool";
    private static final String[] coloredWoolTypes = new String[]{"black", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "white"};

    public EntityWoolGolem(World world) {
        super(world, Config.WOOL.getBaseAttack(), new ItemStack(Blocks.field_150325_L), woolPrefix, coloredWoolTypes);
        this.setCanSwim(true);
    }

    @Override
    public ItemStack getCreativeReturn() {
        ItemStack woolStack = super.getCreativeReturn();
        woolStack.func_77964_b(this.getTextureNum() % (coloredWoolTypes.length + 1));
        return woolStack;
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Config.WOOL.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void addGolemDrops(List<WeightedItem> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + this.field_70146_Z.nextInt(3) + lootingLevel;
        int meta = this.getTextureNum() % coloredWoolTypes.length;
        this.addDrop(dropList, new ItemStack(Blocks.field_150325_L, 1 + this.field_70146_Z.nextInt(2), 0), 100);
        this.addDrop(dropList, Blocks.field_150325_L, meta, 1, 2, 60 + lootingLevel * 10);
        this.addDrop(dropList, Items.field_151007_F, 0, 1, 2, 5 + lootingLevel * 10);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187554_ai;
    }

    @Override
    public void setTextureNum(byte toSet) {
        toSet = (byte)(toSet % (byte)(coloredWoolTypes.length - 1));
        super.setTextureNum(toSet);
    }
}

