/*
 * Decompiled with CFR 0.152.
 */
package com.golems.events;

import com.golems.entity.GolemBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.Event;

@Event.HasResult
public class SpongeGolemSoakEvent
extends Event {
    public List<BlockPos> affectedBlocks;
    public final GolemBase spongeGolem;
    public final BlockPos spongeGolemPos;
    public final int range;
    public int updateFlag = 3;

    public SpongeGolemSoakEvent(GolemBase golem, BlockPos center, int RADIUS) {
        this.setResult(Event.Result.ALLOW);
        this.spongeGolem = golem;
        this.spongeGolemPos = center;
        this.range = RADIUS;
        this.initAffectedBlockList();
    }

    protected void initAffectedBlockList() {
        this.affectedBlocks = new ArrayList<BlockPos>(this.range * this.range * this.range * 4);
        int x = this.spongeGolemPos.func_177958_n();
        int y = this.spongeGolemPos.func_177956_o();
        int z = this.spongeGolemPos.func_177952_p();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = -this.range; j <= this.range; ++j) {
                for (int k = -this.range; k <= this.range; ++k) {
                    BlockPos pos;
                    IBlockState state;
                    if (!(this.spongeGolemPos.func_177954_c((double)(x + i), (double)(y + j), (double)(z + k)) <= (double)(this.range * this.range)) || (state = this.spongeGolem.field_70170_p.func_180495_p(pos = new BlockPos(x + i, y + j, z + k))).func_185904_a() != Material.field_151586_h && state.func_177230_c() != Blocks.field_150355_j && state.func_177230_c() != Blocks.field_150358_i) continue;
                    this.affectedBlocks.add(pos);
                }
            }
        }
    }

    public boolean replaceWater(IBlockState replacesWater) {
        boolean flag = true;
        for (BlockPos p : this.affectedBlocks) {
            if (!this.spongeGolem.field_70170_p.func_180501_a(p, replacesWater, this.updateFlag)) continue;
            flag = true;
        }
        return flag;
    }

    public boolean removeBlockPos(BlockPos toRemove) {
        return this.affectedBlocks.remove(toRemove);
    }
}

