/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityCoalGolem
extends GolemBase {
    public EntityCoalGolem(World world) {
        super(world, 2.5f, Blocks.field_150402_ci);
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(EntityCoalGolem.getGolemTexture("coal"));
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            int BLIND_CHANCE = 4;
            if (Config.ALLOW_COAL_SPECIAL && entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(4) == 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 20 * (1 + this.field_70146_Z.nextInt(5)), 1));
            }
            return true;
        }
        return false;
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(8 + lootingLevel * 2);
        GolemBase.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151044_h, size));
        GolemBase.addDropEntry(dropList, Items.field_151044_h, 1, 1, size / 4, 40);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.field_150501_a;
    }
}

