/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.main.ContentInit;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityEndstoneGolem
extends GolemBase {
    protected int teleportDelay;
    protected double range;
    protected boolean canTeleport;
    protected boolean hasParticles;
    protected int ticksBetweenIdleTeleports = 200;
    protected int chanceToTeleportWhenHurt = 15;

    public EntityEndstoneGolem(World world) {
        this(world, 8.0f, Blocks.field_150377_bs, 32.0, Config.ALLOW_ENDSTONE_SPECIAL, true);
    }

    public EntityEndstoneGolem(World world, float attack, Block pick, double teleportRange, boolean teleportingAllowed, boolean particles) {
        super(world, attack, pick);
        this.range = teleportRange;
        this.canTeleport = teleportingAllowed;
        this.hasParticles = particles;
    }

    public EntityEndstoneGolem(World world, float attack, double teleportRange, boolean teleportingAllowed, boolean particles) {
        this(world, attack, ContentInit.golemHead, teleportRange, teleportingAllowed, particles);
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(EntityEndstoneGolem.getGolemTexture("end_stone"));
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        GolemBase.addDropEntry(dropList, Blocks.field_150377_bs, 0, 2, 2 + lootingLevel, 90);
        GolemBase.addDropEntry(dropList, Items.field_151079_bi, 0, 2, 4 + lootingLevel, 40);
        GolemBase.addDropEntry(dropList, Items.field_151061_bv, 0, 1, 1 + lootingLevel, 6);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.field_150501_a;
    }

    protected boolean teleportTo(double x, double y, double z) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || !this.canTeleport) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; this.hasParticles && l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        if (this.canTeleport) {
            this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
            this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        }
        return true;
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        double d1 = this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * this.range * 0.5;
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * this.range;
        return this.teleportTo(d0, d1, d2);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        for (int k = 0; this.hasParticles && k < 2; ++k) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.teleportToEntity(this.field_70789_a);
            }
        } else if (this.field_70146_Z.nextInt(this.ticksBetweenIdleTeleports) == 0) {
            this.teleportRandomly();
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70789_a != null) {
                if (this.field_70789_a instanceof IMob) {
                    if (this.field_70789_a.func_70068_e((Entity)this) < 16.0) {
                        this.teleportRandomly();
                    }
                    this.teleportDelay = 0;
                } else if (this.field_70789_a.func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity(this.field_70789_a)) {
                    this.teleportDelay = 0;
                }
            } else {
                this.teleportDelay = 0;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 32; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return super.func_70097_a(source, amount);
        }
        if (this.field_70146_Z.nextInt(100) < this.chanceToTeleportWhenHurt || this.field_70789_a != null && this.field_70146_Z.nextBoolean()) {
            this.teleportRandomly();
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean teleportToEntity(Entity entity) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e()), (double)(this.field_70161_v - entity.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }
}

