/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityMelonGolem
extends GolemBase {
    public EntityMelonGolem(World world) {
        super(world, 1.5f, Blocks.field_150440_ba);
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(EntityMelonGolem.getGolemTexture("melon"));
    }

    @Override
    public void func_70636_d() {
        int z;
        int y;
        int x;
        Block blockBelow;
        super.func_70636_d();
        if (Config.ALLOW_MELON_SPECIAL && (blockBelow = this.field_70170_p.func_147439_a(x = MathHelper.func_76128_c((double)this.field_70165_t), y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f - (double)this.field_70129_M)), z = MathHelper.func_76128_c((double)this.field_70161_v))) == Blocks.field_150349_c && this.field_70170_p.func_147437_c(x, y + 1, z)) {
            int PLANT_CHANCE = 160;
            if (this.field_70146_Z.nextInt(160) == 0) {
                this.setToPlant(this.field_70170_p, x, y + 1, z);
            }
        }
    }

    protected void setToPlant(World world, int x, int y, int z) {
        int ranInt = this.field_70146_Z.nextInt(5);
        BlockFlower b = null;
        int meta = 0;
        switch (ranInt) {
            case 0: {
                b = Blocks.field_150328_O;
                meta = this.field_70146_Z.nextInt(9);
                break;
            }
            case 1: {
                b = Blocks.field_150327_N;
                break;
            }
            case 2: {
                b = Blocks.field_150329_H;
                meta = this.field_70146_Z.nextInt(3);
            }
            case 3: {
                b = Blocks.field_150338_P;
                break;
            }
            case 4: {
                b = Blocks.field_150337_Q;
            }
        }
        if (b != null) {
            world.func_147465_d(x, y, z, (Block)b, meta, 3);
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 6 + this.field_70146_Z.nextInt(6 + lootingLevel * 4);
        GolemBase.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151127_ba, size));
        GolemBase.addDropEntry(dropList, Items.field_151081_bc, 0, 1, 6 + lootingLevel, 20 + lootingLevel * 10);
        GolemBase.addDropEntry(dropList, Items.field_151060_bw, 0, 1, 1, 2 + lootingLevel * 10);
    }

    @Override
    public String getGolemSound() {
        return Block.field_149779_h.field_150501_a;
    }
}

