/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import com.golems.main.ContentInit;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntityRedstoneGolem
extends GolemBase {
    public EntityRedstoneGolem(World world) {
        super(world, 2.0f, Blocks.field_150451_bX);
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(EntityRedstoneGolem.getGolemTexture("redstone"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.ALLOW_REDSTONE_SPECIAL && this.field_70173_aa % 2 == 0) {
            this.placePowerNearby();
        }
    }

    public boolean placePowerNearby() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int k = -1; k < 3; ++k) {
            int yPos = y + k;
            if (!this.field_70170_p.func_147437_c(x, yPos, z)) continue;
            return this.field_70170_p.func_147449_b(x, yPos, z, ContentInit.blockPowerProviderFull);
        }
        return false;
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 8 + this.field_70146_Z.nextInt(14 + lootingLevel * 4);
        GolemBase.addGuaranteedDropEntry(dropList, new ItemStack(Items.field_151137_ax, size > 36 ? 36 : size));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149769_e.field_150501_a;
    }
}

