/*
 * Decompiled with CFR 0.152.
 */
package com.golems.entity;

import com.golems.entity.GolemBase;
import com.golems.main.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;

public class EntitySpongeGolem
extends GolemBase {
    public EntitySpongeGolem(World world) {
        super(world, 2.0f, Blocks.field_150360_v);
        this.func_70661_as().func_75491_a(false);
    }

    @Override
    protected void applyTexture() {
        this.setTextureType(EntitySpongeGolem.getGolemTexture("sponge"));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (Config.ALLOW_SPONGE_SPECIAL && (Config.TWEAK_SPONGE_INTERVAL == 1 || this.field_70173_aa % Config.TWEAK_SPONGE_INTERVAL == 0)) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int i = -Config.TWEAK_SPONGE; i <= Config.TWEAK_SPONGE; ++i) {
                for (int j = -Config.TWEAK_SPONGE; j <= Config.TWEAK_SPONGE; ++j) {
                    for (int k = -Config.TWEAK_SPONGE; k <= Config.TWEAK_SPONGE; ++k) {
                        Block b1;
                        if (!(this.func_70011_f(x + i, y + j, z + k) <= (double)Config.TWEAK_SPONGE) || (b1 = this.field_70170_p.func_147439_a(x + i, y + j, z + k)) != Blocks.field_150355_j && b1 != Blocks.field_150358_i && b1.func_149688_o() != Material.field_151586_h) continue;
                        this.field_70170_p.func_147468_f(x + i, y + j, z + k);
                    }
                }
            }
        }
        if (Math.abs(this.field_70159_w) < 0.03 && Math.abs(this.field_70179_y) < 0.03) {
            double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 0.75;
            double d1 = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.5;
            double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 0.75;
            this.field_70170_p.func_72869_a("dripWater", d0, d1, d2, 0.0, -4.0, 0.0);
        }
    }

    @Override
    protected void applyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    @Override
    public void addGolemDrops(List<WeightedRandomChestContent> dropList, boolean recentlyHit, int lootingLevel) {
        int size = 1 + this.field_70146_Z.nextInt(3 + lootingLevel);
        GolemBase.addGuaranteedDropEntry(dropList, new ItemStack(Item.func_150898_a((Block)Blocks.field_150360_v), size > 4 ? 4 : size));
    }

    @Override
    public String getGolemSound() {
        return Block.field_149779_h.field_150501_a;
    }
}

