'mypiano_chung a program by NGUYEN.Chung (freeware 2020)
'#Include Once "gui_chung.bi"
'#Include Once "fbgfx.bi"
#Include Once "bass.bi"
#Include Once "file.bi"

Dim Shared As hstream _sample(128)
Dim Shared As hfx _revsample(128)
Dim Shared As BASS_DX8_REVERB _revparam(128),_revparam0(128)

Declare Sub mypiano_init Cdecl Alias "mypiano_init" (test As Integer=1)
Declare Sub mymidiOutShortMsg Cdecl Alias "mymidioutshortmsg" (UserArg As Integer,MidiMsgvalue As Integer)
Declare Sub mypiano_testnote Cdecl Alias "mypiano_testnote" ()
Declare Sub mypiano_sustain Cdecl Alias "mypiano_sustain" (tsustain As Integer)
Declare Sub mypiano_close Cdecl Alias "mypiano_close" ()

Function _max2(ByVal i As Integer,ByVal j As Integer)As Integer
	If i>=j Then Return i Else Return j
End Function
Function _min2(ByVal i As Integer,ByVal j As Integer)As Integer
	If i<=j Then Return i Else Return j
End Function
Sub mypiano_init Cdecl Alias "mypiano_init" (test As Integer=1) Export 
Dim As ZString * 400 zurl0="piano/piano"+Str(24)+".wav"
Dim As Integer i,j,k 

BASS_Init(-1, 44100, 0,0,0)

For i=24-3 To 108 Step 1
	
	j=Int((i+4)/6+0.001)*6
   Dim As ZString * 400 zurl="piano/piano"+Str(j)+".wav"
   If FileExists(zurl) Then 
     	 _sample(i)=BASS_StreamCreateFile(0, @zurl, 0, 0, 0)'BASS_SAMPLE_LOOP)
     	 If _sample(i)<>0 Then 
     	 	Dim As single freq=44100.0
     	 	Var ret=BASS_ChannelgetAttribute(_sample(i), BASS_ATTRIB_freq, @freq )
     	 	If ret<>0 Then ret=BASS_ChannelsetAttribute(_sample(i), BASS_ATTRIB_freq, freq*2^((i-j)/12))
     	 	_revsample(i)=BASS_ChannelSetFX(_sample(i),BASS_FX_DX8_REVERB,1)
     	 	ret=BASS_FXGetParameters(_revsample(i),@_revparam(i))
     	 	ret=BASS_FXGetParameters(_revsample(i),@_revparam0(i))
     	 EndIf

       If ((i Mod 12)=0 And test=1)Or i=108 Then 
        'guinotice("ok")
        BASS_ChannelPlay(_sample(i),0)
        Sleep 380
        BASS_Channelpause(_sample(i))
        BASS_ChannelSetposition(_sample(i),0,BASS_POS_BYTE)
       EndIf  
   EndIf     
   
   'guiscan
   'If guitestkey(vk_escape) Then Exit For 

Next i
End Sub 

Dim Shared As Integer _noteon(256),_tsustain,_nnote,_tsustain0,_nnote0
Dim Shared As Single _notevelo(256),mypianovol=1
Dim Shared As Double _timenoteon(256),_timenoteoff(256)
Sub mysetrev()
Dim As Integer i,j,k,ret
_nnote0=_nnote
Var krev=(1+_nnote*2)/(2+_nnote)
If _tsustain=1 Then krev=2
Var krevdb=(krev-2)*12
'    float fInGain;
'    float fReverbMix;
'    float fReverbTime;
'    float fHighFreqRTRatio;
For i=24-3 To 108
	If _noteon(i)>0 Or _timenoteoff(i)>1 Then
		'_revparam(i).fHighFreqRTRatio=0.001
		_revparam(i).fReverbTime=500'-i*0.2
		_revparam(i).fReverbMix=krevdb'+_revparam0(i).fReverbMix
		ret=BASS_FXSetParameters(_revsample(i),@_revparam(i))
	EndIf
Next
End Sub 
Sub mymidiOutShortMsg Cdecl Alias "mymidioutshortmsg" (UserArg As Integer,MidiMsgvalue As Integer) Export 
'noteonmsg.value=144+canalout+note*256+veloout*256*256
'noteoffmsg.value=128+canalout+note*256+0*256*256
Var midimsg=midimsgvalue
Var code240=midimsg And 240
Var canal=midimsg And 15
Var note=(midimsg Shr 8)And 255
Var velo=(midimsg Shr 16)And 255
Var dt=Timer 
Var i=note
If code240=176 then 'control
   if note=64 then 'sustain
   	If velo<64 Then
   		_tsustain=0
   	Else 
   		_tsustain=1
   	EndIf
   EndIf 
   Exit Sub 
EndIf 
If canal=9 Then Exit Sub'drum
If code240=144 And velo>0 Then
	_noteon(i)+=1
	If _noteon(i)>=2 Then
		_noteon(i)=1
		velo=_max2(velo,Int(_notevelo(i)*0.5))
	Else
		_nnote+=1
		If _nnote<10 Then mysetrev()
	EndIf 	
	_notevelo(i)=velo
	_timenoteon(i)=dt
	_timenoteoff(i)=0
   Var ret=BASS_ChannelsetAttribute(_sample(i),BASS_ATTRIB_VOL,mypianovol*velo/127)
   BASS_ChannelSetposition(_sample(i),0,BASS_POS_BYTE)
   BASS_ChannelPlay(_sample(i),0)
   Exit Sub 		
EndIf
If code240=128 Or (code240=144 And velo=0) Then
	If _noteon(i)<=0 Then Exit Sub 
   _noteon(i)-=1
	If _noteon(i)<=0 Then
		_timenoteoff(i)=dt
		_nnote-=1
		If _nnote<10 Then mysetrev()
	EndIf
	Exit Sub 
EndIf
 	
End Sub
Sub mypiano_sustain Cdecl Alias "mypiano_sustain" (tsustain As Integer) Export
	_tsustain=tsustain
End Sub 
Dim Shared As Double _timetestnote,_timesustain
Sub mypiano_testnote Cdecl Alias "mypiano_testnote" () Export 
Dim As Integer i,j,k
If Timer<_timetestnote+0.05 Then Exit Sub
Var dt=Timer 
Var trelease=0.120'0.180
If _tsustain>=1 Then trelease=9
Var kdt=max(0.0001,min(1.0,1-(dt-_timetestnote)/trelease))
_timetestnote=dt
Var _nnote2=0
For i=24-3 To 108
	If _noteon(i)>0 Then _nnote2+=1
	If _noteon(i)>4 Then _noteon(i)=4
	If _timenoteon(i)<dt-10 Then
      _noteon(i)=0
      If _timenoteoff(i)<1 Then _timenoteoff(i)=dt 
	EndIf 
	If _noteon(i)<=0 And _timenoteoff(i)>1 Then
		If _timenoteoff(i)<dt-trelease-0.25 Or _notevelo(i)<2 Then
			_timenoteoff(i)=0
         BASS_Channelpause(_sample(i))        
		Else 
	      _notevelo(i)*=kdt
         Var ret=BASS_ChannelsetAttribute(_sample(i),BASS_ATTRIB_VOL,mypianovol*_notevelo(i)/127)
		EndIf
	EndIf
Next
If _nnote2<>_nnote Or _tsustain<>_tsustain0 Or _nnote0<>_nnote Then
	_nnote=_nnote2
	_nnote0=_nnote
	_tsustain0=_tsustain
	mysetrev()
EndIf
If _tsustain=0 Or _nnote>0 Then 
	_timesustain=Timer
ElseIf Timer>_timesustain+10 Then
	_tsustain=0
EndIf
End Sub
Sub mypiano_close Cdecl Alias "mypiano_close" () Export 
Dim As Integer i,j,k
For i=1 To 127
	If _sample(i)<>0 Then BASS_streamFree(_sample(i))
Next

BASS_free()

End Sub
