/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.control.OnTopAlert;
import app.control.mytomato.StackedPanes;
import app.model.TomatoTask;
import app.util.BriefReport;
import app.util.CountDown;
import app.util.DataManager;
import app.util.GL;
import app.util.MapJson;
import app.util.Mp3Player;
import app.util.PropertiesManager;
import app.util.ResGetter;
import app.view.EditDialogControl;
import app.view.FinishDialogController;
import app.view.MainLayoutController;
import app.view.PlusDialogController;
import app.view.RootLayoutController;
import app.view.SettingDialogController;
import app.view.StackedPanesController;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class Main
extends Application {
    public static final int PRIMARY_STAGE_MIN_WIDTH = 415;
    private static final ObservableMap<LocalDate, ObservableList<TomatoTask>> TOMATO_TASKS_MAP = FXCollections.observableMap(new HashMap());
    public static final Duration DEFAULT_WORK_DURATION = Duration.ofMinutes(25L);
    public static final CountDown WORK_COUNT_DOWN = new CountDown(DEFAULT_WORK_DURATION);
    public static final Duration DEFAULT_RESPITE_DURATION = Duration.ofMinutes(5L);
    public static final CountDown RESPITE_COUNT_DOWN = new CountDown(DEFAULT_RESPITE_DURATION);
    public static final Duration DEVELOPMENT_DURATION = Duration.ofSeconds(3L);
    public static final Mp3Player WORK_DURATION_MP3_PLAYER = new Mp3Player(new File(ResGetter.getResFile(), "sound/bgm_Ticking.mp3"));
    public static final Mp3Player RESPITE_DURATION_MP3_PLAYER = new Mp3Player(new File(ResGetter.getResFile(), "sound/bgm_WindThroughTrees.mp3"));
    public static final Mp3Player WORK_FINISHED_MP3_PLAYER = new Mp3Player(new File(ResGetter.getResFile(), "sound/work_finished.mp3"));
    public static final Mp3Player RESPITE_FINISHED_MP3_PLAYER = new Mp3Player(new File(ResGetter.getResFile(), "sound/respite_finished.mp3"));
    public static final PropertiesManager PROPERTIES_MANAGER = PropertiesManager.getPropertiesManager();
    private BorderPane rootLayout;
    private AnchorPane mainLayout;
    private Stage primaryStage;
    private Stage finishDialogStage = null;
    private Stage plusDialogStage = null;
    private Stage startSettingStage = null;
    private Image tomatoImage = new Image(ResGetter.getResURLString() + "image/tomato.png");
    private AnchorPane editDialog;
    private EditDialogControl editDialogController;
    private Stage editDialogStage = null;
    private AnchorPane plusDialog;
    private PlusDialogController plusDialogController;
    private StackedPanesController stackedPanesController;
    private DataManager tomatoTaskDataMapJson;
    private AnchorPane finishDialog;
    private StackedPanes stackedPanes;
    private FinishDialogController finishDialogController;
    private MainLayoutController mainLayoutController;
    private RootLayoutController rootLayoutController;
    private TabPane settingDialog;
    private SettingDialogController settingDialogController;
    private ObservableList<TomatoTask> REDO_TOMATO_TASKS = FXCollections.observableArrayList();
    private final File JSON_FILE = new File(ResGetter.getResFile(), "json\\tomatoTaskData.json");

    public TabPane getSettingDialog() {
        return this.settingDialog;
    }

    public void setSettingDialog(TabPane settingDialog) {
        this.settingDialog = settingDialog;
    }

    public SettingDialogController getSettingDialogController() {
        return this.settingDialogController;
    }

    public void setSettingDialogController(SettingDialogController settingDialogController) {
        this.settingDialogController = settingDialogController;
    }

    public FinishDialogController getFinishDialogController() {
        return this.finishDialogController;
    }

    public void setFinishDialogController(FinishDialogController finishDialogController) {
        this.finishDialogController = finishDialogController;
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public void setPrimaryStage(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    public BorderPane getRootLayout() {
        return this.rootLayout;
    }

    public void setRootLayout(BorderPane rootLayout) {
        this.rootLayout = rootLayout;
    }

    public AnchorPane getMainLayout() {
        return this.mainLayout;
    }

    public void setMainLayout(AnchorPane mainLayout) {
        this.mainLayout = mainLayout;
    }

    public AnchorPane getFinishDialog() {
        return this.finishDialog;
    }

    public void setFinishDialog(AnchorPane finishDialog) {
        this.finishDialog = finishDialog;
    }

    public static ObservableMap<LocalDate, ObservableList<TomatoTask>> getTomatoTasksMap() {
        return TOMATO_TASKS_MAP;
    }

    public DataManager getTomatoTaskDataMapJson() {
        return this.tomatoTaskDataMapJson;
    }

    public MainLayoutController getMainLayoutController() {
        return this.mainLayoutController;
    }

    public void setMainLayoutController(MainLayoutController mainLayoutController) {
        this.mainLayoutController = mainLayoutController;
    }

    public RootLayoutController getRootLayoutController() {
        return this.rootLayoutController;
    }

    public void setRootLayoutController(RootLayoutController rootLayoutController) {
        this.rootLayoutController = rootLayoutController;
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.loadLayout();
        this.intiTomatoTaskData();
        this.setMainAndInitLayout();
        this.initPrimaryStage();
        this.primaryStage.show();
    }

    private void setMainAndInitLayout() {
        this.mainLayoutController.setMainAndInit(this);
        this.finishDialogController.setMainAndInit(this);
        this.plusDialogController.setMainAndInit(this);
        this.rootLayoutController.setMainAndInit(this);
        this.settingDialogController.setMainAndInit(this);
        this.editDialogController.setMainAndInit(this);
        this.stackedPanesController.setMainAndInit(this);
    }

    private void loadLayout() throws IOException {
        this.loadRootLayout();
        this.loadMainLayout();
        this.loadFinishDialog();
        this.loadPlusDialog();
        this.loadSettingDialog();
        this.loadEditDialog();
        this.loadStackedPanes();
    }

    public Main(TabPane settingDialog) {
        this.settingDialog = settingDialog;
    }

    private void loadSettingDialog() {
        try {
            FXMLLoader loader = new FXMLLoader();
            URL name = ((Object)((Object)this)).getClass().getResource("view/SettingDialog.fxml");
            loader.setLocation(name);
            this.settingDialog = (TabPane)loader.load();
            this.settingDialogController = (SettingDialogController)loader.getController();
        }
        catch (IOException e) {
            GL.logger.debug("load SettingDialog fail.", e);
        }
    }

    private void loadEditDialog() {
        try {
            FXMLLoader loader = new FXMLLoader();
            URL name = ((Object)((Object)this)).getClass().getResource("view/EditDialog.fxml");
            loader.setLocation(name);
            this.editDialog = (AnchorPane)loader.load();
            this.editDialogController = (EditDialogControl)loader.getController();
        }
        catch (IOException e) {
            GL.logger.warn(((Object)((Object)this)).getClass().getSimpleName(), e);
        }
    }

    private void initPrimaryStage() {
        this.primaryStage.setTitle("MyTomato");
        Scene primaryStageScene = new Scene((Parent)this.getRootLayout());
        primaryStageScene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("view/stylesheet.css").toExternalForm());
        this.primaryStage.setScene(primaryStageScene);
        this.primaryStage.setMinWidth(415.0);
        this.primaryStage.getIcons().add((Object)this.tomatoImage);
        this.setPrimaryStageListener();
    }

    private void setPrimaryStageListener() {
        this.primaryStage.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> isFocused, Boolean onHidden, Boolean onShown) {
                if (((Boolean)isFocused.getValue()).booleanValue()) {
                    Main.this.mainLayoutController.initHeadText();
                }
            }
        });
        this.primaryStage.setOnCloseRequest(evt -> {
            evt.consume();
            boolean isClosed = this.onStageShutdown(this.primaryStage);
            if (isClosed) {
                System.exit(0);
            }
        });
    }

    private void loadFinishDialog() {
        try {
            FXMLLoader loader = new FXMLLoader();
            URL name = ((Object)((Object)this)).getClass().getResource("view/FinishDialog.fxml");
            loader.setLocation(name);
            this.finishDialog = (AnchorPane)loader.load();
            this.finishDialogController = (FinishDialogController)loader.getController();
        }
        catch (IOException e) {
            GL.logger.warn(((Object)((Object)this)).getClass().getSimpleName(), e);
        }
    }

    public StackedPanesController getStackedPanesController() {
        return this.stackedPanesController;
    }

    public void setStackedPanesController(StackedPanesController stackedPanesController) {
        this.stackedPanesController = stackedPanesController;
    }

    public StackedPanes getStackedPanes() {
        return this.stackedPanes;
    }

    private void loadStackedPanes() {
        this.stackedPanesController = new StackedPanesController();
        this.stackedPanes = this.stackedPanesController.createScrollPane();
    }

    public Stage getPlusDialogStage() {
        return this.plusDialogStage;
    }

    public void setPlusDialogStage(Stage plusDialogStage) {
        this.plusDialogStage = plusDialogStage;
    }

    public AnchorPane getPlusDialog() {
        return this.plusDialog;
    }

    public void setPlusDialog(AnchorPane plusDialog) {
        this.plusDialog = plusDialog;
    }

    public PlusDialogController getPlusDialogController() {
        return this.plusDialogController;
    }

    public void setPlusDialogController(PlusDialogController plusDialogController) {
        this.plusDialogController = plusDialogController;
    }

    private void loadPlusDialog() {
        try {
            FXMLLoader loader = new FXMLLoader();
            URL name = ((Object)((Object)this)).getClass().getResource("view/PlusDialog.fxml");
            loader.setLocation(name);
            this.plusDialog = (AnchorPane)loader.load();
            this.plusDialogController = (PlusDialogController)loader.getController();
        }
        catch (IOException e) {
            GL.logger.warn(((Object)((Object)this)).getClass().getSimpleName(), e);
        }
    }

    public Stage getFinishDialogStage() {
        return this.finishDialogStage;
    }

    public void setFinishDialogStage(Stage finishDialogStage) {
        this.finishDialogStage = finishDialogStage;
    }

    public AnchorPane getEditDialog() {
        return this.editDialog;
    }

    public void setEditDialog(AnchorPane editDialog) {
        this.editDialog = editDialog;
    }

    public EditDialogControl getEditDialogController() {
        return this.editDialogController;
    }

    public void setEditDialogController(EditDialogControl editDialogController) {
        this.editDialogController = editDialogController;
    }

    public Stage getEditDialogStage() {
        return this.editDialogStage;
    }

    public void setEditDialogStage(Stage editDialogStage) {
        this.editDialogStage = editDialogStage;
    }

    public void startEditDialogAndWait(String Title) {
        if (this.editDialogStage == null) {
            this.editDialogStage = new Stage();
            this.editDialogStage.initOwner((Window)this.primaryStage);
            this.editDialogStage.setTitle(Title);
            this.editDialogStage.getIcons().add((Object)this.tomatoImage);
            this.editDialogStage.setScene(new Scene((Parent)this.editDialog));
            this.editDialogStage.setResizable(false);
            this.editDialogStage.setOnCloseRequest(evt -> Platform.runLater(() -> this.getMainLayoutController().getAddButton().setDisable(false)));
        }
        Platform.runLater(() -> this.getMainLayoutController().getAddButton().setDisable(true));
        this.editDialogStage.showAndWait();
    }

    public void startFinishDialogAndWait() {
        if (this.finishDialogStage == null) {
            this.finishDialogStage = new Stage();
            this.finishDialogStage.setAlwaysOnTop(true);
            this.finishDialogStage.initOwner((Window)this.primaryStage);
            this.finishDialogStage.setTitle("\u8bf7\u8f93\u5165\u521a\u521a\u5b8c\u6210\u7684\u4efb\u52a1");
            this.finishDialogStage.getIcons().add((Object)this.tomatoImage);
            this.finishDialogStage.setScene(new Scene((Parent)this.finishDialog));
            this.finishDialogStage.setResizable(false);
            this.finishDialogStage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Main.this.getFinishDialogController().getTextField().setText("");
                            Main.this.getPlusDialogController().getTextField().setText("");
                        }
                    });
                }
            });
            this.finishDialogStage.setOnCloseRequest(evt -> {
                evt.consume();
                this.onStageShutdown(this.finishDialogStage);
            });
        }
        this.finishDialogStage.showAndWait();
    }

    public void startPlusDialogAndWait() {
        if (this.plusDialogStage == null) {
            this.plusDialogStage = new Stage();
            this.plusDialogStage.setAlwaysOnTop(true);
            this.plusDialogStage.initOwner((Window)this.primaryStage);
            this.plusDialogStage.setTitle("\u8bf7\u8f93\u5165\u8981\u63d0\u524d\u6dfb\u52a0\u7684\u4efb\u52a1:");
            this.plusDialogStage.getIcons().add((Object)this.tomatoImage);
            this.plusDialogStage.setScene(new Scene((Parent)this.plusDialog));
            this.plusDialogStage.setResizable(false);
        }
        this.plusDialogStage.showAndWait();
    }

    public void startSettingDialogAndWait() {
        if (this.startSettingStage == null) {
            this.startSettingStage = new Stage();
            this.startSettingStage.setAlwaysOnTop(true);
            this.startSettingStage.setTitle("SettingDialog");
            this.startSettingStage.getIcons().add((Object)this.tomatoImage);
            this.startSettingStage.setScene(new Scene((Parent)this.settingDialog));
            this.startSettingStage.setResizable(false);
        }
        this.startSettingStage.showAndWait();
    }

    private boolean onStageShutdown(Stage mainWindow) {
        OnTopAlert alert = new OnTopAlert(Alert.AlertType.NONE, "Really close the Windows?", ButtonType.YES, ButtonType.NO);
        alert.initOwner((Window)mainWindow);
        if (alert.showAndWait().orElse(ButtonType.NO) == ButtonType.YES) {
            mainWindow.close();
            return true;
        }
        return false;
    }

    public Main() {
    }

    private void intiTomatoTaskData() {
        this.tomatoTaskDataMapJson = new MapJson(TOMATO_TASKS_MAP, this.JSON_FILE);
        this.tomatoTaskDataMapJson.read();
        this.setTomatoTaskDataListener();
        this.setRedoTomatoTaskDataListener();
    }

    private void setRedoTomatoTaskDataListener() {
        this.REDO_TOMATO_TASKS.addListener(change -> {
            if (change.next()) {
                if (this.REDO_TOMATO_TASKS.isEmpty()) {
                    this.mainLayoutController.closeRedoBar();
                } else {
                    this.mainLayoutController.showRedoBarAndSleep();
                }
            }
        });
    }

    public ObservableList<TomatoTask> getREDO_TOMATO_TASKS() {
        return this.REDO_TOMATO_TASKS;
    }

    public void setREDO_TOMATO_TASKS(ObservableList<TomatoTask> REDO_TOMATO_TASKS) {
        this.REDO_TOMATO_TASKS = REDO_TOMATO_TASKS;
    }

    private void setTomatoTaskDataListener() {
        this.getStackedPanes().titledPaneItemsChangeProperty().addListener((observable, oldChange, newChange) -> {
            if (newChange != null && newChange.next()) {
                List removedItems = newChange.getRemoved();
                List addedSubList = newChange.getAddedSubList();
                if (!removedItems.isEmpty()) {
                    this.REDO_TOMATO_TASKS.clear();
                    this.REDO_TOMATO_TASKS.addAll((Collection)removedItems);
                }
                newChange.reset();
            }
        });
    }

    private void loadMainLayout() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        URL name = ((Object)((Object)this)).getClass().getResource("view/MainLayout.fxml");
        loader.setLocation(name);
        this.mainLayout = (AnchorPane)loader.load();
        this.mainLayoutController = (MainLayoutController)loader.getController();
    }

    private void loadRootLayout() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(Main.class.getResource("view/RootLayout.fxml"));
        this.rootLayout = (BorderPane)loader.load();
        this.rootLayoutController = (RootLayoutController)loader.getController();
    }

    public static void main(String[] args) {
        Main.setDefaultUncaughtExceptionHandler();
        Main.launch((String[])args);
    }

    private static void setDefaultUncaughtExceptionHandler() {
        GL.logger.info("setDefaultUncaughtExceptionHandler!");
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            GL.logger.warn("UncaughtException", e);
            BriefReport.formatErrorAlert(e);
        });
    }
}

