/*
 * Decompiled with CFR 0.152.
 */
package app.control;

import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.text.Text;

public class TextWrapCell<T>
extends TableCell<T, String> {
    public int instanceCounter = 0;
    private Text textControl = null;
    public static final int CELL_TEXT_PAD = 20;

    public TextWrapCell() {
        ++this.instanceCounter;
    }

    private void wrap() {
        this.textControl.setWrappingWidth(this.getTableColumn().getWidth() - 20.0);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!this.isEmpty()) {
            if (this.textControl == null) {
                this.setWrapText(true);
                this.textControl = new Text(item);
                this.setGraphic((Node)this.textControl);
                this.wrap();
                this.getTableColumn().widthProperty().addListener((observable, oldValue, newValue) -> this.wrap());
            } else {
                this.textControl.setText(item);
            }
        }
    }
}

