/*
 * Decompiled with CFR 0.152.
 */
package app.control.mytomato;

import app.control.GirdColumn;
import app.control.mytomato.StackedPanes;
import app.model.TomatoTask;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.text.Text;

public class GridPane
extends app.control.GridPane<TomatoTask> {
    public static final int OTHER_CONSTRAINT_WIDTH = 170;
    private GirdColumn<TomatoTask> nameColumn;
    private GirdColumn<TomatoTask> startColumn;
    private GirdColumn<TomatoTask> endColumn;
    private GirdColumn<TomatoTask> deleteColumn;
    private GirdColumn<TomatoTask> editColumn;

    @Override
    public void setItems(ObservableList<TomatoTask> items) {
        this.startColumn = new GirdColumn("start");
        this.startColumn.setNodeFactory(data -> new Text(data.getStartTimeString()));
        this.getColumns().add(this.startColumn);
        this.endColumn = new GirdColumn("end");
        this.endColumn.setNodeFactory(data -> new Text(data.getEndTimeString()));
        this.getColumns().add(this.endColumn);
        this.nameColumn = new GirdColumn("name");
        this.nameColumn.setNodeFactory(data -> {
            Text text = new Text(data.getName());
            text.setWrappingWidth(this.getWidth() - 170.0);
            this.widthProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> text.setWrappingWidth((Double)newValue - 170.0)));
            return text;
        });
        this.getColumns().add(this.nameColumn);
        this.deleteColumn = new GirdColumn("delete");
        this.deleteColumn.setNodeFactory(data -> {
            Button deleteButton = new Button();
            deleteButton.getStyleClass().add((Object)"delete-button");
            deleteButton.setOnAction(event -> items.remove(data));
            return deleteButton;
        });
        this.getColumns().add(this.deleteColumn);
        this.editColumn = new GirdColumn("edit");
        this.editColumn.setNodeFactory(data -> {
            Button editButton = new Button();
            editButton.getStyleClass().add((Object)"edit-button");
            editButton.setOnAction(event -> {
                this.getStackedPanes().setEditingGridPane(this);
                this.getStackedPanes().getStackedPanesController().main.getEditDialogController().loadSpecifiedTask((TomatoTask)data);
                this.getStackedPanes().getStackedPanesController().main.startEditDialogAndWait("\u4fee\u6539\u4efb\u52a1");
            });
            return editButton;
        });
        this.getColumns().add(this.editColumn);
        super.setItems(items);
        this.addListenerToItems();
    }

    private StackedPanes getStackedPanes() {
        Parent parent = this.getParent();
        for (int i = 0; i < Integer.MAX_VALUE && !(parent instanceof StackedPanes); ++i) {
            parent = parent.getParent();
        }
        return (StackedPanes)parent;
    }

    private void addListenerToItems() {
        this.items.addListener(c -> {
            c.next();
            this.generateColumns();
        });
    }

    public void refresh() {
        this.generateColumns();
    }
}

