/*
 * Decompiled with CFR 0.152.
 */
package app.control.mytomato;

import app.control.mytomato.GridPane;
import app.control.mytomato.TitledPane;
import app.model.TomatoTask;
import app.view.StackedPanesController;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;

public class StackedPanes
extends app.control.StackedPanes {
    private GridPane focusedGridPane;
    StackedPanesController stackedPanesController;
    private SimpleObjectProperty<ListChangeListener.Change<? extends TomatoTask>> titledPaneItemsChange = new SimpleObjectProperty();
    protected ObservableMap<LocalDate, ObservableList<TomatoTask>> itemsMap = null;
    protected ObservableList<ObservableList<TomatoTask>> itemsList = FXCollections.observableArrayList();
    private Comparator<? super Node> comparatorTitledPane = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            TitledPane t1 = (TitledPane)o1;
            TitledPane t2 = (TitledPane)o2;
            int result = t1.getLOCAL_DATE().compareTo(t2.getLOCAL_DATE());
            return result;
        }
    };
    private Comparator<ObservableList<TomatoTask>> comparatorTomatoTaskList = (o1, o2) -> {
        boolean o1IsEmpty = o1.isEmpty();
        boolean o2IsEmpty = o2.isEmpty();
        if (o1IsEmpty && o2IsEmpty) {
            return 0;
        }
        if (o1IsEmpty) {
            return -1;
        }
        if (o2IsEmpty) {
            return 1;
        }
        return ((TomatoTask)o1.get(0)).getDate().compareTo(((TomatoTask)o2.get(0)).getDate());
    };

    public StackedPanes() {
        this.vBox.getStyleClass().add((Object)"v-box");
    }

    public StackedPanesController getStackedPanesController() {
        return this.stackedPanesController;
    }

    public void setStackedPanesController(StackedPanesController stackedPanesController) {
        this.stackedPanesController = stackedPanesController;
    }

    public ListChangeListener.Change<? extends TomatoTask> getTitledPaneItemsChange() {
        return (ListChangeListener.Change)this.titledPaneItemsChange.get();
    }

    public SimpleObjectProperty<ListChangeListener.Change<? extends TomatoTask>> titledPaneItemsChangeProperty() {
        return this.titledPaneItemsChange;
    }

    public void setTitledPaneItemsChange(ListChangeListener.Change<? extends TomatoTask> titledPaneItemsChange) {
        this.titledPaneItemsChange.set(titledPaneItemsChange);
    }

    public ObservableMap<LocalDate, ObservableList<TomatoTask>> getItemsMap() {
        return this.itemsMap;
    }

    public void setItemsMap(ObservableMap<LocalDate, ObservableList<TomatoTask>> itemsMap) {
        this.itemsMap = itemsMap;
        this.convertItemsMapToSortedList();
        this.showItemsList();
        itemsMap.addListener(change -> {
            ObservableList addList = (ObservableList)change.getValueAdded();
            if (!addList.isEmpty()) {
                this.addTitledPane((ObservableList<TomatoTask>)addList);
            }
        });
    }

    private void addTitledPane(ObservableList<TomatoTask> addList) {
        if (!addList.isEmpty()) {
            TitledPane titledPane = this.creatTitledPane(addList);
            ArrayList<TitledPane> list2 = new ArrayList<TitledPane>((Collection<TitledPane>)this.vBox.getChildren());
            list2.add(titledPane);
            list2.sort(this.comparatorTitledPane);
            Collections.reverse(list2);
            this.vBox.getChildren().clear();
            this.vBox.getChildren().addAll(list2);
        }
    }

    public void removeTitledPane(TitledPane titledPane) {
        this.vBox.getChildren().remove((Object)titledPane);
    }

    private void showItemsList() {
        this.itemsList.forEach(list2 -> {
            if (!list2.isEmpty()) {
                TitledPane titledPane = this.creatTitledPane((ObservableList<TomatoTask>)list2);
                this.vBox.getChildren().add((Object)titledPane);
            }
        });
    }

    private TitledPane creatTitledPane(ObservableList<TomatoTask> list2) {
        TitledPane titledPane = new TitledPane(((TomatoTask)list2.get(0)).getDate());
        titledPane.setItems(list2);
        list2.addListener(change -> {
            if (change.next()) {
                List removedItems = change.getRemoved();
                List addedSubList = change.getAddedSubList();
                boolean sortAble = !addedSubList.isEmpty() | !removedItems.isEmpty();
                if (sortAble) {
                    // empty if block
                }
                change.reset();
            }
            if (list2.isEmpty()) {
                this.removeTitledPane(titledPane);
            }
            this.setTitledPaneItemsChange((ListChangeListener.Change<? extends TomatoTask>)change);
        });
        return titledPane;
    }

    private void convertItemsMapToSortedList() {
        this.itemsMap.forEach((localDate, list2) -> {
            this.itemsList.add(list2);
            this.itemsList.sort(this.comparatorTomatoTaskList);
        });
        Collections.reverse(this.itemsList);
    }

    public void addItems(TomatoTask ... tomatoTasks) {
        for (int i = 0; i < tomatoTasks.length; ++i) {
            this.addItem(tomatoTasks[i]);
        }
    }

    public void addItems(List<TomatoTask> items) {
        for (int i = 0; i < items.size(); ++i) {
            this.addItem(items.get(i));
        }
    }

    private void addItem(TomatoTask tomatoTask) {
        ObservableList list2 = (ObservableList)this.itemsMap.get((Object)tomatoTask.getDate());
        if (list2 == null || list2.isEmpty()) {
            ObservableList newList = FXCollections.observableArrayList((Object[])new TomatoTask[]{tomatoTask});
            this.itemsMap.put((Object)tomatoTask.getDate(), (Object)newList);
        } else {
            list2.add((Object)tomatoTask);
        }
    }

    public GridPane getFocusedGridPane() {
        return this.focusedGridPane;
    }

    public void setEditingGridPane(GridPane focusedGridPane) {
        this.focusedGridPane = focusedGridPane;
    }
}

