/*
 * Decompiled with CFR 0.152.
 */
package app.model;

import app.util.CountDown;
import app.util.DateAndTime;
import java.time.LocalDate;
import java.time.LocalTime;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class TomatoTask {
    private StringProperty name;
    private ObjectProperty<LocalTime> startTime = new SimpleObjectProperty();
    private ObjectProperty<LocalTime> endTime = new SimpleObjectProperty();
    private ObjectProperty<LocalDate> date = new SimpleObjectProperty();
    private StringProperty startTimeString;
    private StringProperty endTimeString;
    private StringProperty dateString;

    public LocalDate getDate() {
        return (LocalDate)this.date.get();
    }

    public ObjectProperty<LocalDate> dateProperty() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date.set((Object)date);
    }

    public String getDateString() {
        return (String)this.dateString.get();
    }

    public StringProperty dateStringProperty() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString.set((Object)dateString);
    }

    public LocalTime getEndTime() {
        return (LocalTime)this.endTime.get();
    }

    public ObjectProperty<LocalTime> endTimeProperty() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime.set((Object)endTime);
    }

    public TomatoTask(String name, CountDown countDown) {
        this.initTomatoTask(name, countDown.getStartTime(), countDown.getEndTime());
    }

    public TomatoTask(String name, LocalTime startTime, LocalTime endTime) {
        this.initTomatoTask(name, startTime, endTime);
    }

    public TomatoTask(String name, LocalTime startTime, LocalTime endTime, LocalDate date) {
        this.initTomatoTask(name, startTime, endTime, date);
    }

    public void initTomatoTask(String name, LocalTime startTime, LocalTime endTime) {
        this.name = new SimpleStringProperty(name);
        this.addLockTimeListener();
        this.setEndTime(endTime);
        this.setStartTime(startTime);
        this.setDate(LocalDate.now());
    }

    public void initTomatoTask(String name, LocalTime startTime, LocalTime endTime, LocalDate date) {
        this.name = new SimpleStringProperty(name);
        this.addLockTimeListener();
        this.setEndTime(endTime);
        this.setStartTime(startTime);
        this.setDate(date);
    }

    private void addLockTimeListener() {
        this.startTime.addListener((observable, oldValue, newValue) -> {
            LocalTime startTime = newValue;
            String startTimeString = DateAndTime.localTimeToString(startTime);
            this.startTimeString = new SimpleStringProperty(startTimeString);
        });
        this.endTime.addListener((observable, oldValue, newValue) -> {
            LocalTime endTime = newValue;
            String endTimeString = DateAndTime.localTimeToString(endTime);
            this.endTimeString = new SimpleStringProperty(endTimeString);
        });
        this.date.addListener((observable, oldValue, newValue) -> {
            LocalDate date = newValue;
            String dateString = DateAndTime.localDateToString(date);
            this.dateString = new SimpleStringProperty(dateString);
        });
    }

    public String toString() {
        return "TomatoTask{name=" + this.name + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", date=" + this.date + '}';
    }

    public TomatoTask(String name, LocalTime endTime) {
        LocalTime startTime = LocalTime.now();
        this.initTomatoTask(name, startTime, endTime);
    }

    public String getEndTimeString() {
        return (String)this.endTimeString.get();
    }

    public StringProperty endTimeStringProperty() {
        return this.endTimeString;
    }

    public void setEndTimeString(String endTimeString) {
        this.endTimeString.set((Object)endTimeString);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public LocalTime getStartTime() {
        return (LocalTime)this.startTime.get();
    }

    public ObjectProperty<LocalTime> startTimeProperty() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime.set((Object)startTime);
    }

    public String getStartTimeString() {
        return (String)this.startTimeString.get();
    }

    public StringProperty startTimeStringProperty() {
        return this.startTimeString;
    }

    public void setStartTimeString(String startTimeString) {
        this.startTimeString.set((Object)startTimeString);
    }
}

