/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import java.time.Duration;
import java.time.LocalTime;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class CountDown {
    private volatile Duration duration;
    private volatile LocalTime startTime;
    private volatile LocalTime endTime;
    private volatile LocalTime currentTime;
    private volatile Duration sumDuration;
    private volatile Duration zeroDuration = Duration.ofSeconds(0L);
    private volatile Duration currentDuration;
    private volatile SimpleBooleanProperty started = new SimpleBooleanProperty(false);
    private volatile SimpleBooleanProperty finished = new SimpleBooleanProperty(false);
    public static final int PERIOD_MSEC = 100;
    private volatile StringProperty textProgress = new SimpleStringProperty("");
    private volatile DoubleProperty barProgress = new SimpleDoubleProperty(0.0);
    private static volatile Timer time;
    public static final long TIMER_DELAY = 0L;
    private ReentrantLock startOrStopLock = new ReentrantLock();
    private ReentrantLock startedLock = new ReentrantLock();
    private ReentrantLock finishedLock = new ReentrantLock();

    public StringProperty textProgressProperty() {
        return this.textProgress;
    }

    public void setTextProgress(String textProgress) {
        this.textProgress.set((Object)textProgress);
    }

    public DoubleProperty barProgressProperty() {
        return this.barProgress;
    }

    public void setBarProgress(double barProgress) {
        this.barProgress.set(barProgress);
    }

    public CountDown(Duration duration) {
        this.duration = duration;
    }

    public SimpleBooleanProperty finishedProperty() {
        this.finishedLock.lock();
        try {
            SimpleBooleanProperty simpleBooleanProperty = this.finished;
            return simpleBooleanProperty;
        }
        finally {
            this.finishedLock.unlock();
        }
    }

    public boolean getFinished() {
        this.finishedLock.lock();
        try {
            boolean bl = this.finished.get();
            return bl;
        }
        finally {
            this.finishedLock.unlock();
        }
    }

    public void setFinished(boolean finished) {
        this.finishedLock.lock();
        try {
            this.finished.set(finished);
        }
        finally {
            this.finishedLock.unlock();
        }
    }

    public SimpleBooleanProperty startedProperty() {
        this.finishedLock.lock();
        try {
            SimpleBooleanProperty simpleBooleanProperty = this.started;
            return simpleBooleanProperty;
        }
        finally {
            this.finishedLock.unlock();
        }
    }

    public void setStarted(boolean started) {
        this.startedLock.lock();
        try {
            this.started.set(started);
        }
        finally {
            this.startedLock.unlock();
        }
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public boolean isStarted() {
        this.startedLock.lock();
        try {
            boolean bl = this.started.get();
            return bl;
        }
        finally {
            this.startedLock.unlock();
        }
    }

    public void start() {
        this.startOrStopLock.lock();
        try {
            if (this.isStarted()) {
                throw new RuntimeException("Already started. Cannot be started again.");
            }
            this.setStarted(true);
            this.initProgressData();
            this.startTimer();
            this.setFinished(false);
        }
        finally {
            this.startOrStopLock.unlock();
        }
    }

    private void startTimer() {
        time = new Timer();
        time.schedule(new TimerTask(){

            @Override
            public void run() {
                CountDown.this.updateProgressText();
                CountDown.this.updateProgressBar();
                CountDown.this.checkProgress();
            }
        }, 0L, 100L);
    }

    public void cancel() {
        this.stop(false);
    }

    public void finish() {
        this.stop(true);
    }

    public void stop(boolean finished) {
        this.startOrStopLock.lock();
        try {
            if (!this.isStarted()) {
                throw new RuntimeException("Already stopped. Cannot be stopped again.");
            }
            this.setStarted(false);
            this.progressReturnToZero();
            time.cancel();
            this.setFinished(finished);
        }
        finally {
            this.startOrStopLock.unlock();
        }
    }

    private void checkProgress() {
        if (this.currentDuration.compareTo(this.zeroDuration) >= 0) {
            this.finish();
        }
    }

    public static Timer getTime() {
        return time;
    }

    public static void setTime(Timer time) {
        CountDown.time = time;
    }

    private void initProgressData() {
        this.currentTime = LocalTime.now();
        this.startTime = LocalTime.from(this.currentTime);
        this.endTime = LocalTime.from(this.currentTime).plus(this.duration);
        this.sumDuration = Duration.between(this.startTime, this.endTime);
        this.currentDuration = Duration.between(this.startTime, this.currentTime);
    }

    public static String formatDuration(Duration duration, Boolean alwaysPositive) {
        long seconds = duration.getSeconds();
        long absSeconds = Math.abs(seconds);
        String positive = String.format("%d:%02d:%02d", absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L);
        return seconds < 0L & alwaysPositive == false ? "-" + positive : positive;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    private void progressReturnToZero() {
        this.setTextProgress("");
        this.setBarProgress(0.0);
    }

    private void updateProgressText() {
        this.currentTime = LocalTime.now();
        this.currentDuration = Duration.between(this.endTime, this.currentTime);
        this.setTextProgress(CountDown.formatDuration(this.currentDuration, true));
    }

    private void updateProgressBar() {
        long currentSec = Math.abs(this.currentDuration.toMillis());
        long sumSec = Math.abs(this.sumDuration.toMillis());
        double progress = (double)currentSec / (double)sumSec;
        this.setBarProgress(progress);
    }
}

