/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import app.control.OnTopAlert;
import app.model.TomatoTask;
import app.util.DataManager;
import app.util.GL;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class ListJson
implements DataManager {
    private final String EMPTY_MAP_STRING = "[]";
    private final File jsonFile;
    private List<TomatoTask> data;

    public List<TomatoTask> getData() {
        return this.data;
    }

    public ListJson(List<TomatoTask> data, File jsonFile) {
        GL.logger.info("JsonFile:" + jsonFile.getAbsolutePath());
        this.jsonFile = jsonFile;
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readString() {
        char[] json = new char[(int)this.jsonFile.length()];
        String jsonString = "";
        try {
            try (FileReader fileReader = new FileReader(this.jsonFile);){
                fileReader.read(json);
                jsonString = new String(json);
                return jsonString;
            }
            catch (FileNotFoundException e) {
                System.err.println("Not Found JSON ,set table empty\uff01");
                jsonString = "[]";
                return jsonString;
            }
            catch (IOException e) {
                GL.logger.warn(this.getClass().getSimpleName(), e);
            }
        }
        finally {
            return jsonString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String write() {
        ArrayList<TomatoTask> tomatoTaskList = new ArrayList<TomatoTask>(this.data);
        String json = JSON.toJSONString(tomatoTaskList);
        try {
            try (FileWriter fileWriter = new FileWriter(this.jsonFile);){
                fileWriter.write(json);
                return json;
            }
            catch (IOException e) {
                GL.logger.warn(this.getClass().getSimpleName(), e);
            }
        }
        finally {
            return json;
        }
    }

    @Override
    public void read() {
        this.data.clear();
        String jsonString = this.readString();
        ArrayList jsonList = null;
        try {
            jsonList = JSON.parseObject(jsonString, ArrayList.class);
            jsonList.forEach(jsonMap -> this.mapToTask((JSONObject)jsonMap));
        }
        catch (JSONException e) {
            GL.logger.warn(this.getClass().getSimpleName(), e);
            OnTopAlert alert = new OnTopAlert(Alert.AlertType.WARNING, "JSON file parse exception.", new ButtonType[0]);
            alert.showAndWait();
            System.exit(1);
        }
    }

    private void mapToTask(JSONObject jsonMap) {
        String name = (String)jsonMap.get("name");
        LocalTime endTime = LocalTime.parse((String)jsonMap.get("endTime"));
        LocalTime startTime = LocalTime.parse((String)jsonMap.get("startTime"));
        LocalDate date = LocalDate.parse((String)jsonMap.get("date"));
        this.data.add(new TomatoTask(name, startTime, endTime, date));
    }
}

