/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import app.model.TomatoTask;
import app.util.DataManager;
import app.util.ListJson;
import java.io.File;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class MapJson
implements DataManager {
    private final ObservableList<TomatoTask> listData = FXCollections.observableArrayList();
    private final ObservableMap<LocalDate, ObservableList<TomatoTask>> mapData;
    private final File jsonFile;
    private final ListJson listJson;

    public MapJson(ObservableMap<LocalDate, ObservableList<TomatoTask>> mapData, File jsonFile) {
        this.mapData = mapData;
        this.jsonFile = jsonFile;
        this.listJson = new ListJson((List<TomatoTask>)this.listData, jsonFile);
    }

    @Override
    public String write() {
        this.convertToList();
        return this.listJson.write();
    }

    @Override
    public void read() {
        this.listJson.read();
        this.convertToMap();
    }

    private void convertToMap() {
        this.listData.forEach(e -> {
            if (this.mapData.get((Object)e.getDate()) == null) {
                this.mapData.put((Object)e.getDate(), (Object)FXCollections.observableArrayList());
            }
            ((ObservableList)this.mapData.get((Object)e.getDate())).add(e);
        });
    }

    private void convertToList() {
        this.listData.clear();
        this.mapData.forEach((k, v) -> this.listData.addAll((Collection)v));
    }
}

