/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import app.util.GL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.concurrent.atomic.AtomicBoolean;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;

public class Mp3Player {
    private File file;
    private FileInputStream fileInputStream;
    private Player player;
    private AtomicBoolean repeated = new AtomicBoolean(false);

    public Mp3Player(File file) {
        this.file = file;
        try {
            this.fileInputStream = new FileInputStream(this.file);
            this.player = new Player(this.fileInputStream);
        }
        catch (FileNotFoundException e) {
            GL.logger.warn(this.getClass().getSimpleName(), e);
        }
        catch (JavaLayerException e) {
            GL.logger.warn(this.getClass().getSimpleName(), e);
        }
    }

    private void repeatPlay() {
        this.repeated.set(true);
        while (this.repeated.get()) {
            this.play();
        }
    }

    public void close() {
        this.repeated.set(false);
        this.player.close();
    }

    public void playInNewThread() {
        new Thread(this::play, "playInNewThread").start();
    }

    private void play() {
        try {
            this.fileInputStream = new FileInputStream(this.file);
            this.player = new Player(this.fileInputStream);
            this.player.play();
        }
        catch (JavaLayerException e) {
            GL.logger.warn(this.getClass().getSimpleName(), e);
        }
        catch (FileNotFoundException e) {
            GL.logger.warn(this.getClass().getSimpleName(), e);
        }
    }

    public void repeatPlayInNewThread() {
        new Thread(this::repeatPlay, "repeatPlayInNewThread").start();
    }
}

