/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import app.util.GL;
import app.util.ResGetter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class PropertiesManager {
    private Properties settings = new Properties();
    private static PropertiesManager propertiesManager = null;
    private File propertiesFile;
    private static final String PROPERTIES_DIR_PATH = "properties";

    private PropertiesManager() {
        this.initFile();
    }

    public static PropertiesManager getPropertiesManager() {
        if (propertiesManager == null) {
            propertiesManager = new PropertiesManager();
        }
        return propertiesManager;
    }

    private void initFile() {
        File propertiesDir = new File(ResGetter.getResFile(), PROPERTIES_DIR_PATH);
        if (!propertiesDir.exists()) {
            propertiesDir.mkdir();
        }
        this.propertiesFile = new File(propertiesDir, "Settings.properties");
        this.createFileIfNotExist();
        this.loadSettings();
    }

    private void createFileIfNotExist() {
        if (!this.propertiesFile.exists()) {
            try {
                FileOutputStream out = new FileOutputStream(this.propertiesFile);
                Throwable throwable = null;
                if (out != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
            catch (FileNotFoundException e) {
                GL.logger.warn(this.getClass().getSimpleName(), e);
            }
            catch (IOException e) {
                GL.logger.warn(this.getClass().getSimpleName(), e);
            }
        }
    }

    public String getProperty(String key, String defaultValue) {
        this.loadSettings();
        return this.settings.getProperty(key, defaultValue);
    }

    private void loadSettings() {
        try (FileInputStream in = new FileInputStream(this.propertiesFile);){
            this.settings.load(in);
        }
        catch (IOException e) {
            GL.logger.warn(this.getClass().getSimpleName(), e);
        }
    }

    public void setProperty(String key, String newValue) {
        this.settings.setProperty(key, newValue);
        this.storeSettings();
    }

    private void storeSettings() {
        try (FileOutputStream out = new FileOutputStream(this.propertiesFile);){
            this.settings.store(out, "Program Properties");
        }
        catch (IOException e) {
            GL.logger.warn(this.getClass().getSimpleName(), e);
        }
    }
}

