/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import app.util.GL;
import com.sun.glass.ui.Window;
import com.sun.javafx.stage.StageHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.stage.Stage;
import org.bridj.Pointer;
import org.bridj.cpp.com.COMRuntime;
import org.bridj.cpp.com.shell.ITaskbarList3;

public final class TaskBarProgressbar {
    private final Stage stage;
    private ExecutorService es;
    private ITaskbarList3 list;
    private Pointer<?> hwnd;

    private TaskBarProgressbar() {
        this.stage = null;
        this.es = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        this.es.execute(() -> {
            try {
                this.list = COMRuntime.newInstance(ITaskbarList3.class);
            }
            catch (ClassNotFoundException e) {
                GL.logger.warn(this.getClass().getSimpleName(), e);
            }
        });
    }

    public TaskBarProgressbar(Stage stage) {
        this.stage = stage;
        this.es = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        this.es.execute(() -> {
            try {
                this.list = COMRuntime.newInstance(ITaskbarList3.class);
            }
            catch (ClassNotFoundException e) {
                GL.logger.warn(this.getClass().getSimpleName(), e);
            }
        });
    }

    public void close() {
        this.es.submit(() -> this.list.Release());
    }

    public void stopProgress() {
        long hwndVal = ((Window)Window.getWindows().get(StageHelper.getStages().indexOf((Object)this.stage))).getNativeWindow();
        this.hwnd = Pointer.pointerToAddress(hwndVal);
        this.es.execute(() -> this.list.SetProgressState(this.hwnd, TaskBarProgressbarType.NOPROGRESS.getPair()));
    }

    public void showIndeterminateProgress() {
        long hwndVal = ((Window)Window.getWindows().get(StageHelper.getStages().indexOf((Object)this.stage))).getNativeWindow();
        this.hwnd = Pointer.pointerToAddress(hwndVal);
        this.es.execute(() -> this.list.SetProgressState(this.hwnd, TaskBarProgressbarType.INDETERMINATE.getPair()));
    }

    public void showOtherProgress(long startValue, long endValue, TaskBarProgressbarType type) {
        long hwndVal = ((Window)Window.getWindows().get(StageHelper.getStages().indexOf((Object)this.stage))).getNativeWindow();
        this.hwnd = Pointer.pointerToAddress(hwndVal);
        this.es.execute(() -> {
            this.list.SetProgressValue(this.hwnd, startValue, endValue);
            this.list.SetProgressState(this.hwnd, type.getPair());
        });
    }

    public void showOtherProgress(double value, TaskBarProgressbarType type) {
        int endValue = 100;
        int startValue = (int)(value *= 100.0);
        this.showOtherProgress(startValue, endValue, type);
    }

    public void showErrorProgress() {
        long hwndVal = ((Window)Window.getWindows().get(StageHelper.getStages().indexOf((Object)this.stage))).getNativeWindow();
        this.hwnd = Pointer.pointerToAddress(hwndVal);
        this.es.execute(() -> {
            this.list.SetProgressValue(this.hwnd, 100L, 100L);
            this.list.SetProgressState(this.hwnd, TaskBarProgressbarType.ERROR.getPair());
        });
    }

    public static void stopProgress(int windowIndex) {
        TaskBarProgressbar progressbar = new TaskBarProgressbar();
        long hwndVal = ((Window)Window.getWindows().get(windowIndex)).getNativeWindow();
        progressbar.hwnd = Pointer.pointerToAddress(hwndVal);
        progressbar.es.execute(() -> progressbar.list.SetProgressState(progressbar.hwnd, TaskBarProgressbarType.NOPROGRESS.getPair()));
    }

    public static void showIndeterminateProgress(int windowIndex) {
        TaskBarProgressbar progressbar = new TaskBarProgressbar();
        long hwndVal = ((Window)Window.getWindows().get(windowIndex)).getNativeWindow();
        progressbar.hwnd = Pointer.pointerToAddress(hwndVal);
        progressbar.es.execute(() -> progressbar.list.SetProgressState(progressbar.hwnd, TaskBarProgressbarType.INDETERMINATE.getPair()));
    }

    public static void showOtherProgress(int windowIndex, long startValue, long endValue, TaskBarProgressbarType type) {
        TaskBarProgressbar progressbar = new TaskBarProgressbar();
        long hwndVal = ((Window)Window.getWindows().get(windowIndex)).getNativeWindow();
        progressbar.hwnd = Pointer.pointerToAddress(hwndVal);
        progressbar.es.execute(() -> {
            progressbar.list.SetProgressValue(progressbar.hwnd, startValue, endValue);
            progressbar.list.SetProgressState(progressbar.hwnd, type.getPair());
        });
    }

    public static void showErrorProgress(int windowIndex) {
        TaskBarProgressbar progressbar = new TaskBarProgressbar();
        long hwndVal = ((Window)Window.getWindows().get(windowIndex)).getNativeWindow();
        progressbar.hwnd = Pointer.pointerToAddress(hwndVal);
        progressbar.es.execute(() -> {
            progressbar.list.SetProgressValue(progressbar.hwnd, 100L, 100L);
            progressbar.list.SetProgressState(progressbar.hwnd, TaskBarProgressbarType.ERROR.getPair());
        });
    }

    public static enum TaskBarProgressbarType {
        ERROR{

            @Override
            ITaskbarList3.TbpFlag getPair() {
                return ITaskbarList3.TbpFlag.TBPF_ERROR;
            }
        }
        ,
        INDETERMINATE{

            @Override
            ITaskbarList3.TbpFlag getPair() {
                return ITaskbarList3.TbpFlag.TBPF_INDETERMINATE;
            }
        }
        ,
        NOPROGRESS{

            @Override
            ITaskbarList3.TbpFlag getPair() {
                return ITaskbarList3.TbpFlag.TBPF_NOPROGRESS;
            }
        }
        ,
        NORMAL{

            @Override
            ITaskbarList3.TbpFlag getPair() {
                return ITaskbarList3.TbpFlag.TBPF_NORMAL;
            }
        }
        ,
        PAUSED{

            @Override
            ITaskbarList3.TbpFlag getPair() {
                return ITaskbarList3.TbpFlag.TBPF_PAUSED;
            }
        };


        abstract ITaskbarList3.TbpFlag getPair();
    }
}

