/*
 * Decompiled with CFR 0.152.
 */
package app.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeStringPolisher {
    private String srcText;
    public static final String CHECK_REGEX = "\\d+:\\d+";
    public static final String SPLIT_REGEX = "\\d+";
    private String minuteString;
    private String hourString;
    private int minute;
    private int hour;
    private String polishedText;

    public TimeStringPolisher(String srcText) {
        this.srcText = srcText;
    }

    public String polish() {
        this.preCheck();
        this.splitString();
        this.parseToInt();
        this.numberRangeCheck();
        this.polishedText = String.format("%02d:%02d", this.hour, this.minute);
        return this.polishedText;
    }

    private void numberRangeCheck() {
        boolean isMinuteMatched;
        boolean isHourMatched;
        boolean bl = isHourMatched = this.hour >= 0 && this.hour <= 23;
        if (!isHourMatched) {
            String hourFormat = "Text '%s' could not be parsed:valid values is 0-23.";
            throw new RuntimeException(String.format(hourFormat, this.hourString));
        }
        boolean bl2 = isMinuteMatched = this.minute >= 0 && this.minute <= 59;
        if (!isMinuteMatched) {
            String minuteFormat = "Text '%s' could not be parsed:valid values is 0-59.";
            throw new RuntimeException(String.format(minuteFormat, this.minuteString));
        }
    }

    private void parseToInt() {
        this.hour = Integer.valueOf(this.hourString);
        this.minute = Integer.valueOf(this.minuteString);
    }

    private void splitString() {
        Pattern pattern = Pattern.compile(SPLIT_REGEX);
        Matcher matcher = pattern.matcher(this.srcText);
        matcher.find();
        this.hourString = matcher.group();
        matcher.find();
        this.minuteString = matcher.group();
    }

    private void preCheck() {
        boolean isMatched = Pattern.matches(CHECK_REGEX, this.srcText);
        if (!isMatched) {
            String mes = String.format("Text'%s' could not be parsed:valid values is \\d+:\\d+(RegEx).", this.srcText);
            throw new RuntimeException(mes);
        }
    }
}

