/*
 * Decompiled with CFR 0.152.
 */
package app.view;

import app.Main;
import app.control.OnTopAlert;
import app.model.TomatoTask;
import app.util.GL;
import app.util.TimeStringPolisher;
import app.view.Controller;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;

public class EditDialogControl
extends Controller {
    private static final String EMPTY_TASK_NAME = "";
    public static final int MINUTES_TO_ADD = -25;
    public static final String CHINESE_COLON = "\uff1a";
    public static final String ENGLISH_COLON = ":";
    public static final int DIGIT_AMOUNT_OF_TIME_STRING = 4;
    public static final int ENGLISH_COLON_INSERT_OFFSET = 2;
    @FXML
    private DatePicker datePicker;
    @FXML
    private TextField startTime;
    @FXML
    private TextField endTime;
    @FXML
    private TextArea taskName;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;
    private final SimpleObjectProperty<TomatoTask> CURRENT_TOMATO_TASK = new SimpleObjectProperty();
    private AtomicBoolean isNewTask = new AtomicBoolean();

    public TomatoTask getCURRENT_TOMATO_TASK() {
        return (TomatoTask)this.CURRENT_TOMATO_TASK.get();
    }

    public SimpleObjectProperty<TomatoTask> CURRENT_TOMATO_TASKProperty() {
        return this.CURRENT_TOMATO_TASK;
    }

    public void setCURRENT_TOMATO_TASK(TomatoTask CURRENT_TOMATO_TASK) {
        this.CURRENT_TOMATO_TASK.set((Object)CURRENT_TOMATO_TASK);
    }

    @FXML
    private void handleOkButton() {
        OnTopAlert alert;
        ButtonType selectButton;
        this.getCURRENT_TOMATO_TASK().setDate((LocalDate)this.datePicker.getValue());
        this.getCURRENT_TOMATO_TASK().setStartTime(LocalTime.parse(this.startTime.getText()));
        this.getCURRENT_TOMATO_TASK().setEndTime(LocalTime.parse(this.endTime.getText()));
        String taskName = this.taskName.getText();
        if (taskName.isEmpty() && (selectButton = (ButtonType)(alert = new OnTopAlert(Alert.AlertType.WARNING, "\u786e\u5b9a\u8981\u63d0\u4ea4\u4e00\u4e2a\u7a7a\u4efb\u52a1\u5417\uff1f", ButtonType.NO, ButtonType.YES)).showAndWait().get()).equals(ButtonType.NO)) {
            return;
        }
        this.getCURRENT_TOMATO_TASK().setName(taskName);
        if (this.isNewTask.get()) {
            Platform.runLater(() -> this.main.getStackedPanes().addItems(this.getCURRENT_TOMATO_TASK()));
        } else {
            this.main.getTomatoTaskDataMapJson().write();
            this.main.getStackedPanes().getFocusedGridPane().refresh();
        }
        this.main.getEditDialogStage().close();
        Platform.runLater(() -> this.main.getMainLayoutController().getAddButton().setDisable(false));
    }

    @FXML
    private void handleCancelButton() {
        this.main.getEditDialogStage().close();
    }

    public void loadNewTask() {
        this.isNewTask.set(true);
        LocalTime endTime = LocalTime.now();
        this.setCURRENT_TOMATO_TASK(new TomatoTask(EMPTY_TASK_NAME, this.getStartTime(endTime), endTime));
    }

    public void loadSpecifiedTask(TomatoTask tomatoTask) {
        this.isNewTask.set(false);
        this.setCURRENT_TOMATO_TASK(tomatoTask);
    }

    private LocalTime getStartTime(LocalTime endTime) {
        LocalTime startTime = LocalTime.from(endTime);
        Duration duration = Duration.ofMinutes(-25L);
        startTime = startTime.plus(duration);
        return startTime;
    }

    @Override
    public void setMainAndInit(Main main) {
        super.setMainAndInit(main);
        this.currentTomatoTaskBind();
        this.textFieldCheck();
    }

    private void textFieldCheck() {
        this.startTime.textProperty().addListener((ChangeListener)new TimeFieldTrueCheck(this.startTime));
        this.endTime.textProperty().addListener((ChangeListener)new TimeFieldTrueCheck(this.endTime));
        this.startTime.focusedProperty().addListener((ChangeListener)new TimeFieldCheckWhenLoseFocus(this.startTime));
        this.endTime.focusedProperty().addListener((ChangeListener)new TimeFieldCheckWhenLoseFocus(this.endTime));
    }

    private boolean onlyContainTimeChar(String newText) {
        char[] charArray;
        for (char c : charArray = newText.toCharArray()) {
            if (this.isDigitOrEnglishColon(c)) continue;
            return false;
        }
        return true;
    }

    private boolean onlyContainDigit(String newText) {
        char[] charArray;
        for (char c : charArray = newText.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isDigitOrEnglishColon(char c) {
        String letterOrDigital = "0123456789";
        return -1 != (letterOrDigital = letterOrDigital + ENGLISH_COLON).indexOf(c);
    }

    private void currentTomatoTaskBind() {
        this.CURRENT_TOMATO_TASKProperty().addListener((observable, oldTomatoTask, newTomatoTask) -> {
            if (newTomatoTask != null) {
                this.datePicker.setValue((Object)newTomatoTask.getDate());
                this.startTime.setText(newTomatoTask.getStartTimeString());
                this.endTime.setText(newTomatoTask.getEndTimeString());
                this.taskName.setWrapText(true);
                this.taskName.setText(newTomatoTask.getName());
            }
        });
    }

    public class TimeFieldCheckWhenLoseFocus
    implements ChangeListener<Boolean> {
        private TextField textField;
        private String correctFormatString;

        public TimeFieldCheckWhenLoseFocus(TextField textField) {
            this.textField = textField;
            this.correctFormatString = textField.getText();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldIsFocused, Boolean newIsFocused) {
            if (newIsFocused.booleanValue()) {
                this.correctFormatString = this.textField.getText();
            } else {
                TimeStringPolisher timeStringPolisher = new TimeStringPolisher(this.textField.getText());
                String newText = null;
                try {
                    newText = timeStringPolisher.polish();
                }
                catch (Exception e) {
                    GL.logger.warn(this.getClass().getSimpleName(), e);
                    newText = this.correctFormatString;
                }
                finally {
                    this.textField.setText(newText);
                }
            }
        }
    }

    public class TimeFieldTrueCheck
    implements ChangeListener<String> {
        private TextField textField;

        public TimeFieldTrueCheck(TextField textField) {
            this.textField = textField;
        }

        public void changed(ObservableValue<? extends String> observable, String oldText, String newText) {
            boolean autoSwap;
            boolean notOnlyContainTimeChar;
            if (newText.contains(EditDialogControl.CHINESE_COLON)) {
                newText = newText.replace(EditDialogControl.CHINESE_COLON, EditDialogControl.ENGLISH_COLON);
            }
            boolean bl = notOnlyContainTimeChar = !EditDialogControl.this.onlyContainTimeChar(newText);
            if (notOnlyContainTimeChar) {
                newText = oldText;
            }
            boolean bl2 = autoSwap = EditDialogControl.this.onlyContainDigit(newText) && newText.length() == 4;
            if (autoSwap) {
                StringBuilder sb = new StringBuilder(newText);
                sb.insert(2, EditDialogControl.ENGLISH_COLON);
                newText = sb.toString();
            }
            this.textField.setText(newText);
        }
    }
}

