/*
 * Decompiled with CFR 0.152.
 */
package app.view;

import app.Main;
import app.control.OnTopAlert;
import app.model.TomatoTask;
import app.util.TaskBarProgressbar;
import app.view.Controller;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.text.Text;

public class MainLayoutController
extends Controller {
    public static final String START = "Start";
    public static final String STOP = "Stop";
    public static final int FIRST_INDEX = 0;
    private final int REDO_DELETE_BAR_SHOW_MILLIS = 5000;
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private TableColumn<TomatoTask, String> startColumn;
    @FXML
    private TableColumn<TomatoTask, String> endColumn;
    @FXML
    private TableColumn<TomatoTask, String> nameColumn;
    @FXML
    private TableColumn<TomatoTask, String> dateColumn;
    @FXML
    private Button startOrStopButton;
    @FXML
    private Button plusButton;
    @FXML
    private Button addButton;
    @FXML
    private Button redoDeleteButton;
    @FXML
    private Text progressText;
    @FXML
    private Text headText;
    @FXML
    private ProgressBar progressBar;
    TaskBarProgressbar taskProgressbar = null;
    @FXML
    private FlowPane buttonFlowPane;
    @FXML
    private FlowPane buttonFlowPaneBackground;
    private int todayTaskAmount = 0;
    private Thread showRedoBarAndSleepThread;
    private static final Double STACKED_PANE_MARGIN = 5.0;
    private static final Double STACKED_PANE_MARGIN_TOP = 80.0;
    private ReentrantLock startOrStopLock = new ReentrantLock();
    ChangeListener<? super Number> selectedIndexListener = (observable, oldSelectedIndex, newSelectedIndex) -> {
        int selectedIndex = (Integer)newSelectedIndex;
        boolean disable = selectedIndex < 0;
    };

    public Button getStartOrStopButton() {
        return this.startOrStopButton;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getPlusButton() {
        return this.plusButton;
    }

    public TableColumn<TomatoTask, String> getNameColumn() {
        return this.nameColumn;
    }

    public void setNameColumn(TableColumn<TomatoTask, String> nameColumn) {
        this.nameColumn = nameColumn;
    }

    @FXML
    private void handleRedoDelete() {
        ObservableList<TomatoTask> removedItems = this.main.getREDO_TOMATO_TASKS();
        if (!removedItems.isEmpty()) {
            this.main.getStackedPanes().addItems((List<TomatoTask>)removedItems);
            removedItems.clear();
        }
    }

    @FXML
    private void handlePlusButton() {
        this.main.startPlusDialogAndWait();
    }

    @FXML
    private void handleAddButton() {
        this.main.getEditDialogController().loadNewTask();
        this.main.startEditDialogAndWait("\u6dfb\u52a0\u65b0\u4efb\u52a1");
    }

    @FXML
    private void handleStartOrStopButton() {
        if (this.startOrStopButton.getText().equals(START)) {
            this.handleStartButton();
        } else if (this.startOrStopButton.getText().equals(STOP)) {
            this.handleStopButton();
        }
    }

    private void handleStopButton() {
        this.startOrStopLock.lock();
        try {
            if (Main.WORK_COUNT_DOWN.isStarted()) {
                Main.WORK_COUNT_DOWN.cancel();
                Main.WORK_DURATION_MP3_PLAYER.close();
            }
            if (Main.RESPITE_COUNT_DOWN.isStarted()) {
                Main.RESPITE_COUNT_DOWN.cancel();
                Main.RESPITE_DURATION_MP3_PLAYER.close();
            }
        }
        finally {
            this.startOrStopLock.unlock();
        }
    }

    private void handleStartButton() {
        this.startOrStopLock.lock();
        try {
            Main.WORK_COUNT_DOWN.start();
            Main.WORK_DURATION_MP3_PLAYER.repeatPlayInNewThread();
        }
        finally {
            this.startOrStopLock.unlock();
        }
    }

    private void handleWorkFinished() {
        this.handleWorkFinished(true);
    }

    private void handleWorkFinished(boolean ableMusic) {
        Main.WORK_DURATION_MP3_PLAYER.close();
        if (ableMusic) {
            Main.WORK_FINISHED_MP3_PLAYER.playInNewThread();
        }
        Platform.runLater(() -> {
            this.getStartOrStopButton().setDisable(true);
            this.main.startFinishDialogAndWait();
            this.getStartOrStopButton().setDisable(false);
        });
    }

    private void sizeBind() {
        this.anchorSizeBindAndInit();
    }

    private void setSettingListenerAndSetDuration() {
        boolean checked = this.main.getSettingDialogController().getDevelopmentCheckBox().isSelected();
        this.developmentMode(checked);
        this.main.getSettingDialogController().getDevelopmentCheckBox().selectedProperty().addListener((observable, oldValue, newValue) -> this.developmentMode((Boolean)newValue));
    }

    private void anchorSizeBindAndInit() {
        this.anchorWidthBindAndInit();
        this.anchorHeightBindAndInit();
    }

    private void anchorHeightBindAndInit() {
        String heightString = Main.PROPERTIES_MANAGER.getProperty("anchorHeight", Double.toString(this.anchorPane.getPrefHeight()));
        double height = Double.parseDouble(heightString);
        this.anchorPane.setPrefHeight(height);
        this.anchorPane.heightProperty().addListener((observable, oldValue, newValue) -> {
            double anchorHeight = (Double)newValue;
            Main.PROPERTIES_MANAGER.setProperty("anchorHeight", Double.toString(anchorHeight));
        });
    }

    private void anchorWidthBindAndInit() {
        String widthString = Main.PROPERTIES_MANAGER.getProperty("anchorWidth", Double.toString(this.anchorPane.getPrefWidth()));
        double width = Double.parseDouble(widthString);
        this.anchorPane.setPrefWidth(width);
        this.anchorPane.widthProperty().addListener((observable, oldValue, newValue) -> {
            double anchorWidth = (Double)newValue;
            Main.PROPERTIES_MANAGER.setProperty("anchorWidth", Double.toString(anchorWidth));
        });
    }

    private void setRespiteCountDownListener() {
        Main.RESPITE_COUNT_DOWN.startedProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            boolean isStarted = newValue;
            if (isStarted) {
                this.startOrStopButton.setText(STOP);
                this.progressBar.setStyle("-fx-accent: #ffc800");
            } else {
                this.startOrStopButton.setText(START);
            }
        }));
        Main.RESPITE_COUNT_DOWN.barProgressProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            this.progressBar.setProgress(((Double)newValue).doubleValue());
            this.taskProgressbar.showOtherProgress((Double)newValue, TaskBarProgressbar.TaskBarProgressbarType.PAUSED);
        }));
        Main.RESPITE_COUNT_DOWN.textProgressProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.progressText.setText(newValue)));
        Main.RESPITE_COUNT_DOWN.finishedProperty().addListener((observable, oldValue, newValue) -> {
            boolean finished = newValue;
            if (finished) {
                Main.RESPITE_DURATION_MP3_PLAYER.close();
                Main.RESPITE_FINISHED_MP3_PLAYER.playInNewThread();
                Platform.runLater(() -> {
                    OnTopAlert respiteFinishedAlert = new OnTopAlert(Alert.AlertType.INFORMATION, "\u4f11\u606f\u5df2\u7ed3\u675f\uff0c\u662f\u5426\u5f00\u542f\u4e0b\u4e00\u4e2a\u756a\u8304\uff1f", ButtonType.YES, ButtonType.NO);
                    respiteFinishedAlert.setTitle("\u4f11\u606f\u5df2\u7ed3\u675f");
                    respiteFinishedAlert.setHeaderText("\u4f11\u606f\u5df2\u7ed3\u675f");
                    ButtonType buttonType = respiteFinishedAlert.showAndWait().orElse(ButtonType.YES);
                    if (buttonType.equals(ButtonType.YES)) {
                        this.handleStartButton();
                    }
                });
            }
        });
    }

    private void setWorkCountDownListener() {
        Main.WORK_COUNT_DOWN.startedProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            boolean isStarted = newValue;
            if (isStarted) {
                this.startOrStopButton.setText(STOP);
                this.getPlusButton().setDisable(false);
                this.progressBar.setStyle("-fx-accent: #328e2e");
            } else {
                this.startOrStopButton.setText(START);
                this.getPlusButton().setDisable(true);
            }
        }));
        Main.WORK_COUNT_DOWN.barProgressProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            this.progressBar.setProgress(((Double)newValue).doubleValue());
            this.taskProgressbar.showOtherProgress((Double)newValue, TaskBarProgressbar.TaskBarProgressbarType.NORMAL);
        }));
        Main.WORK_COUNT_DOWN.textProgressProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.progressText.setText(newValue)));
        Main.WORK_COUNT_DOWN.finishedProperty().addListener((observable, oldValue, newValue) -> {
            boolean finished = newValue;
            if (finished) {
                this.handleWorkFinished();
            }
        });
    }

    private void developmentMode(Boolean newValue) {
        if (newValue.booleanValue()) {
            Main.WORK_COUNT_DOWN.setDuration(Main.DEVELOPMENT_DURATION);
            Main.RESPITE_COUNT_DOWN.setDuration(Main.DEVELOPMENT_DURATION);
        } else {
            Main.WORK_COUNT_DOWN.setDuration(Main.DEFAULT_WORK_DURATION);
            Main.RESPITE_COUNT_DOWN.setDuration(Main.DEFAULT_RESPITE_DURATION);
        }
    }

    private void addTaskNameAfterFinished(String taskName) {
        OnTopAlert alert;
        ButtonType selectButton;
        if ((taskName == null || taskName.isEmpty()) && (selectButton = (ButtonType)(alert = new OnTopAlert(Alert.AlertType.WARNING, "\u786e\u5b9a\u8981\u63d0\u4ea4\u4e00\u4e2a\u7a7a\u4efb\u52a1\u5417\uff1f", ButtonType.NO, ButtonType.YES)).showAndWait().get()).equals(ButtonType.NO)) {
            Platform.runLater(() -> this.main.startFinishDialogAndWait());
            return;
        }
        TomatoTask tomatoTask = new TomatoTask(taskName, Main.WORK_COUNT_DOWN);
        this.main.getStackedPanes().addItems(tomatoTask);
        Main.RESPITE_COUNT_DOWN.start();
        Main.RESPITE_DURATION_MP3_PLAYER.repeatPlayInNewThread();
    }

    @Override
    public void setMainAndInit(Main main) {
        super.setMainAndInit(main);
        this.initHeadText();
        this.headTextBind();
        this.setWorkCountDownListener();
        this.setRespiteCountDownListener();
        this.sizeBind();
        this.initCountDownText();
        this.setSettingListenerAndSetDuration();
        this.setStackedPanes();
        this.taskProgressbar = new TaskBarProgressbar(main.getPrimaryStage());
    }

    private void setStackedPanes() {
        this.main.getStackedPanes().setPrefHeight(240.0);
        AnchorPane.setTopAnchor((Node)this.main.getStackedPanes(), (Double)STACKED_PANE_MARGIN_TOP);
        AnchorPane.setBottomAnchor((Node)this.main.getStackedPanes(), (Double)STACKED_PANE_MARGIN);
        AnchorPane.setLeftAnchor((Node)this.main.getStackedPanes(), (Double)STACKED_PANE_MARGIN);
        AnchorPane.setRightAnchor((Node)this.main.getStackedPanes(), (Double)STACKED_PANE_MARGIN);
        Node temp = (Node)this.anchorPane.getChildren().get(0);
        this.anchorPane.getChildren().set(0, (Object)this.main.getStackedPanes());
        this.anchorPane.getChildren().add((Object)temp);
    }

    private void updateHeadText() {
        this.headText.setText("\u4eca\u65e5\u5df2\u5b8c\u6210 " + this.todayTaskAmount + " \u4e2a\u756a\u8304");
    }

    public void initHeadText() {
        this.todayTaskAmount = this.getCertainDayTaskAmount(Main.getTomatoTasksMap(), LocalDate.now());
        this.updateHeadText();
    }

    private void headTextBind() {
        this.main.getStackedPanes().titledPaneItemsChangeProperty().addListener((observable, oldValue, newValue) -> this.initHeadText());
    }

    private int getCertainDayTaskAmount(ObservableMap<LocalDate, ObservableList<TomatoTask>> map, LocalDate date) {
        ObservableList CertainDayTaskList = (ObservableList)map.get((Object)date);
        if (CertainDayTaskList == null) {
            return 0;
        }
        return CertainDayTaskList.size();
    }

    private void initCountDownText() {
        this.progressText.setText("");
    }

    public void showRedoBarAndSleep() {
        this.showRedoBarAndSleepThread = new Thread(() -> {
            this.showRedoBar();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.hideRedoBar();
            }
        }, "showRedoBar");
        this.showRedoBarAndSleepThread.start();
    }

    private void hideRedoBar() {
        Platform.runLater(() -> {
            this.buttonFlowPaneBackground.setVisible(false);
            this.buttonFlowPane.setVisible(false);
        });
    }

    public void closeRedoBar() {
        if (this.showRedoBarAndSleepThread != null) {
            this.showRedoBarAndSleepThread.interrupt();
        }
    }

    private void showRedoBar() {
        Platform.runLater(() -> {
            this.buttonFlowPaneBackground.setVisible(true);
            this.buttonFlowPane.setVisible(true);
        });
    }
}

